/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.batch.api;

import io.weaviate.client.base.util.BeaconPath;
import io.weaviate.client.v1.batch.model.BatchReference;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ReferencePayloadBuilder {
    private final BeaconPath beaconPath;
    private String fromUUID;
    private String fromClassName;
    private String fromPropertyName;
    private String toUUID;
    private String toClassName;

    @Deprecated
    public ReferencePayloadBuilder() {
        this.beaconPath = null;
        System.err.println("WARNING: Deprecated constructor for ReferencePayloadBuilder class was used. Please use parametrized one.");
    }

    public ReferencePayloadBuilder(BeaconPath beaconPath) {
        this.beaconPath = Objects.requireNonNull(beaconPath);
    }

    public ReferencePayloadBuilder withFromID(String uuid) {
        this.fromUUID = uuid;
        return this;
    }

    public ReferencePayloadBuilder withFromClassName(String className) {
        this.fromClassName = className;
        return this;
    }

    public ReferencePayloadBuilder withFromRefProp(String propertyName) {
        this.fromPropertyName = propertyName;
        return this;
    }

    public ReferencePayloadBuilder withToID(String uuid) {
        this.toUUID = uuid;
        return this;
    }

    public ReferencePayloadBuilder withToClassName(String className) {
        this.toClassName = className;
        return this;
    }

    public BatchReference payload() {
        String to;
        String from;
        if (StringUtils.isBlank((CharSequence)this.fromClassName) || StringUtils.isBlank((CharSequence)this.fromUUID) || StringUtils.isBlank((CharSequence)this.fromPropertyName) || StringUtils.isBlank((CharSequence)this.toUUID)) {
            return null;
        }
        if (this.beaconPath != null) {
            from = this.beaconPath.buildBatchFrom(BeaconPath.Params.builder().id(this.fromUUID).className(this.fromClassName).property(this.fromPropertyName).build());
            to = this.beaconPath.buildBatchTo(BeaconPath.Params.builder().id(this.toUUID).className(this.toClassName).build());
        } else {
            from = this.beaconFromDeprecated();
            to = this.beaconToDeprecated();
        }
        return BatchReference.builder().from(from).to(to).build();
    }

    private String beaconFromDeprecated() {
        return String.format("weaviate://localhost/%s/%s/%s", this.fromClassName, this.fromUUID, this.fromPropertyName);
    }

    private String beaconToDeprecated() {
        return String.format("weaviate://localhost/%s", this.toUUID);
    }
}

