/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.data.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.v1.data.model.SingleRef;
import io.weaviate.client.v1.data.util.ReferencesPath;
import java.util.Objects;

public class ReferenceDeleter
extends BaseClient<Object>
implements ClientResult<Boolean> {
    private final ReferencesPath referencesPath;
    private String id;
    private String className;
    private String consistencyLevel;
    private String referenceProperty;
    private SingleRef referencePayload;

    public ReferenceDeleter(HttpClient httpClient, Config config, ReferencesPath referencesPath) {
        super(httpClient, config);
        this.referencesPath = Objects.requireNonNull(referencesPath);
    }

    public ReferenceDeleter withID(String id) {
        this.id = id;
        return this;
    }

    public ReferenceDeleter withClassName(String className) {
        this.className = className;
        return this;
    }

    public ReferenceDeleter withConsistencyLevel(String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public ReferenceDeleter withReferenceProperty(String propertyName) {
        this.referenceProperty = propertyName;
        return this;
    }

    public ReferenceDeleter withReference(SingleRef referencePayload) {
        this.referencePayload = referencePayload;
        return this;
    }

    @Override
    public Result<Boolean> run() {
        String path = this.referencesPath.buildDelete(ReferencesPath.Params.builder().id(this.id).className(this.className).consistencyLevel(this.consistencyLevel).property(this.referenceProperty).build());
        Response<Object> resp = this.sendDeleteRequest(path, this.referencePayload, Object.class);
        return new Result<Boolean>(resp.getStatusCode(), resp.getStatusCode() == 204, resp.getErrors());
    }
}

