/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class AskArgument
implements Argument {
    private final String question;
    private final String[] properties;
    private final Float certainty;
    private final Float distance;
    private final Boolean autocorrect;
    private final Boolean rerank;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)this.question)) {
            arg.add(String.format("question: \"%s\"", this.question));
        }
        if (this.properties != null && this.properties.length > 0) {
            String props = Stream.of(this.properties).map(f -> String.format("\"%s\"", f)).collect(Collectors.joining(", "));
            arg.add(String.format("properties: [%s]", props));
        }
        if (this.certainty != null) {
            arg.add(String.format("certainty: %s", this.certainty));
        }
        if (this.distance != null) {
            arg.add(String.format("distance: %s", this.distance));
        }
        if (this.autocorrect != null) {
            arg.add(String.format("autocorrect: %s", this.autocorrect));
        }
        if (this.rerank != null) {
            arg.add(String.format("rerank: %s", this.rerank));
        }
        return String.format("ask: {%s}", StringUtils.joinWith((String)" ", (Object[])arg.toArray()));
    }

    AskArgument(String question, String[] properties, Float certainty, Float distance, Boolean autocorrect, Boolean rerank) {
        this.question = question;
        this.properties = properties;
        this.certainty = certainty;
        this.distance = distance;
        this.autocorrect = autocorrect;
        this.rerank = rerank;
    }

    public static AskArgumentBuilder builder() {
        return new AskArgumentBuilder();
    }

    public String getQuestion() {
        return this.question;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public Float getDistance() {
        return this.distance;
    }

    public Boolean getAutocorrect() {
        return this.autocorrect;
    }

    public Boolean getRerank() {
        return this.rerank;
    }

    public String toString() {
        return "AskArgument(question=" + this.getQuestion() + ", properties=" + Arrays.deepToString(this.getProperties()) + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ", autocorrect=" + this.getAutocorrect() + ", rerank=" + this.getRerank() + ")";
    }

    public static class AskArgumentBuilder {
        private String question;
        private String[] properties;
        private Float certainty;
        private Float distance;
        private Boolean autocorrect;
        private Boolean rerank;

        AskArgumentBuilder() {
        }

        public AskArgumentBuilder question(String question) {
            this.question = question;
            return this;
        }

        public AskArgumentBuilder properties(String[] properties) {
            this.properties = properties;
            return this;
        }

        public AskArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public AskArgumentBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        public AskArgumentBuilder autocorrect(Boolean autocorrect) {
            this.autocorrect = autocorrect;
            return this;
        }

        public AskArgumentBuilder rerank(Boolean rerank) {
            this.rerank = rerank;
            return this;
        }

        public AskArgument build() {
            return new AskArgument(this.question, this.properties, this.certainty, this.distance, this.autocorrect, this.rerank);
        }

        public String toString() {
            return "AskArgument.AskArgumentBuilder(question=" + this.question + ", properties=" + Arrays.deepToString(this.properties) + ", certainty=" + this.certainty + ", distance=" + this.distance + ", autocorrect=" + this.autocorrect + ", rerank=" + this.rerank + ")";
        }
    }
}

