/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management;

import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class VersionInfo
implements com.sun.jbi.VersionInfo {
    @Override
    public String fullProductName() {
        return "Open Enterprise Service Bus";
    }

    @Override
    public String shortProductName() {
        return "Open_ESB";
    }

    @Override
    public String majorVersion() {
        return VersionInfo.getManifestImplementationMajorVersion();
    }

    @Override
    public String minorVersion() {
        return VersionInfo.getManifestImplementationMinorVersion();
    }

    @Override
    public String buildNumber() {
        return VersionInfo.getManifestImplementationBuildNumber();
    }

    @Override
    public String copyright() {
        return "Under Common Development and Distribution License (CDDL). For more information, please visit www.open-esb.net";
    }

    private static String getManifestImplementationMajorVersion() {
        String version;
        Attributes attrs = VersionInfo.getManifestAttributes();
        if (attrs != null && (version = attrs.getValue("Implementation-MajorVersion")) != null) {
            return version;
        }
        return null;
    }

    private static String getManifestImplementationMinorVersion() {
        String version;
        Attributes attrs = VersionInfo.getManifestAttributes();
        if (attrs != null && (version = attrs.getValue("Implementation-MinorVersion")) != null) {
            return version;
        }
        return null;
    }

    private static String getManifestImplementationBuildNumber() {
        String version;
        Attributes attrs = VersionInfo.getManifestAttributes();
        if (attrs != null && (version = attrs.getValue("Implementation-Build")) != null) {
            return version;
        }
        return null;
    }

    private static Attributes getManifestAttributes() {
        try {
            URL url = VersionInfo.class.getProtectionDomain().getCodeSource().getLocation();
            JarFile jar = new JarFile(url.getFile());
            return jar.getManifest().getMainAttributes();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

