/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.wsdl2.impl;

import com.sun.jbi.wsdl2.impl.DescriptionImpl;
import com.sun.jbi.wsdl2.impl.Document;
import com.sun.jbi.wsdl2.impl.ExtensibleDocumentedComponent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.w3.ns.wsdl.DocumentationType;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

final class DocumentImpl
extends Document {
    private DocumentationType mBean;
    private ExtensibleDocumentedComponent mParent;
    private DescriptionImpl mContainer;

    DocumentationType getBean() {
        return this.mBean;
    }

    private DocumentImpl(DocumentationType bean, ExtensibleDocumentedComponent parent, DescriptionImpl defs) {
        this.mBean = bean;
        this.mParent = parent;
        this.mContainer = defs;
    }

    public DocumentFragment getDocumentation() {
        XmlOptions opts = new XmlOptions().setSaveOuter().setSaveAggresiveNamespaces();
        DocumentFragment result = (DocumentFragment)this.getBean().newDomNode(opts);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocumentation(DocumentFragment theDocumentFragment) {
        if (theDocumentFragment != null) {
            DocumentationType newBean = null;
            try {
                newBean = DocumentationType.Factory.parse(theDocumentFragment);
            }
            catch (XmlException ex) {
                // empty catch block
            }
            if (newBean == null) {
                org.w3c.dom.Document doc = theDocumentFragment.getOwnerDocument();
                Element elm = doc.createElementNS("http://www.w3.org/ns/wsdl", "documentation");
                elm.appendChild(theDocumentFragment);
                try {
                    newBean = DocumentationType.Factory.parse(elm);
                }
                catch (XmlException ex) {
                    System.err.println("Error parsing documentation fragment");
                    System.err.println(ex.getMessage());
                    System.err.println(ex.getError().toString());
                    ex.printStackTrace(System.err);
                }
            }
            if (newBean != null) {
                Map map;
                DocumentationType oldBean = this.getBean();
                Map map2 = map = this.mContainer.getDocumentMap();
                synchronized (map2) {
                    int theIndex;
                    map.put(newBean, map.remove(oldBean));
                    DocumentationType[] docTypeArray = this.mParent.getExBean().getDocumentationArray();
                    ArrayList<DocumentationType> theList = new ArrayList<DocumentationType>();
                    if (docTypeArray != null) {
                        for (int i = 0; i < docTypeArray.length; ++i) {
                            theList.add(i, docTypeArray[i]);
                        }
                    }
                    if ((theIndex = theList.indexOf(oldBean)) != -1) {
                        theList.set(theIndex, newBean);
                    } else {
                        theList.add(newBean);
                    }
                    this.mParent.getExBean().setDocumentationArray((DocumentationType[])theList.toArray());
                }
            }
        }
    }

    static class Factory {
        Factory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static DocumentImpl getInstance(DocumentationType bean, ExtensibleDocumentedComponent parent, DescriptionImpl defs) {
            DocumentImpl result;
            if (bean != null) {
                Map map;
                Map map2 = map = defs.getDocumentMap();
                synchronized (map2) {
                    result = (DocumentImpl)map.get(bean);
                    if (result == null) {
                        result = new DocumentImpl(bean, parent, defs);
                        map.put(bean, result);
                    }
                }
            } else {
                result = null;
            }
            return result;
        }
    }
}

