/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

public abstract class PropertySourcesUtils {
    public static Map<String, Object> getPrefixedProperties(Iterable<PropertySource<?>> propertySources, String prefix) {
        MutablePropertySources mutablePropertySources = new MutablePropertySources();
        for (PropertySource<?> source : propertySources) {
            mutablePropertySources.addLast(source);
        }
        return PropertySourcesUtils.getPrefixedProperties((PropertySources)mutablePropertySources, prefix);
    }

    public static Map<String, Object> getPrefixedProperties(PropertySources propertySources, String prefix) {
        PropertySourcesPropertyResolver propertyResolver = new PropertySourcesPropertyResolver(propertySources);
        LinkedHashMap<String, Object> prefixedProperties = new LinkedHashMap<String, Object>();
        String normalizedPrefix = PropertySourcesUtils.buildPrefix(prefix);
        for (PropertySource source : propertySources) {
            if (!(source instanceof EnumerablePropertySource)) continue;
            for (String name : ((EnumerablePropertySource)source).getPropertyNames()) {
                String subName;
                if (prefixedProperties.containsKey(name) || !name.startsWith(normalizedPrefix) || prefixedProperties.containsKey(subName = name.substring(normalizedPrefix.length()))) continue;
                Object value = source.getProperty(name);
                if (value instanceof String) {
                    value = propertyResolver.resolvePlaceholders((String)value);
                }
                prefixedProperties.put(subName, value);
            }
        }
        return Collections.unmodifiableMap(prefixedProperties);
    }

    public static String buildPrefix(String prefix) {
        if (prefix.endsWith(".")) {
            return prefix;
        }
        return prefix + ".";
    }
}

