/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.ToStringUtils;

public class TermsQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(TermsQuery.class);
    private final int[] offsets;
    private final byte[] termsBytes;
    private final TermsAndField[] termsAndFields;
    private final int hashCode;

    public TermsQuery(final List<Term> terms) {
        this(new FieldAndTermEnum(){
            final Iterator<Term> iter;
            {
                this.iter = TermsQuery.sort(terms).iterator();
            }

            @Override
            public BytesRef next() {
                if (this.iter.hasNext()) {
                    Term next = this.iter.next();
                    this.field = next.field();
                    return next.bytes();
                }
                return null;
            }
        }, terms.size());
    }

    public TermsQuery(String field, final List<BytesRef> terms) {
        this(new FieldAndTermEnum(field){
            final Iterator<BytesRef> iter;
            {
                super(x0);
                this.iter = TermsQuery.sort(terms).iterator();
            }

            @Override
            public BytesRef next() {
                if (this.iter.hasNext()) {
                    return this.iter.next();
                }
                return null;
            }
        }, terms.size());
    }

    public TermsQuery(String field, BytesRef ... terms) {
        this(field, Arrays.asList(terms));
    }

    public TermsQuery(Term ... terms) {
        this(Arrays.asList(terms));
    }

    private TermsQuery(FieldAndTermEnum iter, int length) {
        int start;
        BytesRef currentTerm;
        int hash = 9;
        byte[] serializedTerms = new byte[]{};
        this.offsets = new int[length + 1];
        int lastEndOffset = 0;
        int index = 0;
        ArrayList<TermsAndField> termsAndFields = new ArrayList<TermsAndField>();
        TermsAndField lastTermsAndField = null;
        BytesRef previousTerm = null;
        String previousField = null;
        while ((currentTerm = iter.next()) != null) {
            String currentField = iter.field();
            if (currentField == null) {
                throw new IllegalArgumentException("Field must not be null");
            }
            if (previousField != null) {
                if (previousField.equals(currentField)) {
                    if (previousTerm.bytesEquals(currentTerm)) {
                        continue;
                    }
                } else {
                    start = lastTermsAndField == null ? 0 : lastTermsAndField.end;
                    lastTermsAndField = new TermsAndField(start, index, previousField);
                    termsAndFields.add(lastTermsAndField);
                }
            }
            hash = 31 * hash + currentField.hashCode();
            hash = 31 * hash + currentTerm.hashCode();
            if (serializedTerms.length < lastEndOffset + currentTerm.length) {
                serializedTerms = ArrayUtil.grow((byte[])serializedTerms, (int)(lastEndOffset + currentTerm.length));
            }
            System.arraycopy(currentTerm.bytes, currentTerm.offset, serializedTerms, lastEndOffset, currentTerm.length);
            this.offsets[index] = lastEndOffset;
            lastEndOffset += currentTerm.length;
            ++index;
            previousTerm = currentTerm;
            previousField = currentField;
        }
        this.offsets[index] = lastEndOffset;
        start = lastTermsAndField == null ? 0 : lastTermsAndField.end;
        lastTermsAndField = new TermsAndField(start, index, previousField);
        termsAndFields.add(lastTermsAndField);
        this.termsBytes = ArrayUtil.shrink((byte[])serializedTerms, (int)lastEndOffset);
        this.termsAndFields = termsAndFields.toArray(new TermsAndField[termsAndFields.size()]);
        this.hashCode = hash;
    }

    public boolean equals(Object obj) {
        int lastOffset;
        if (!super.equals(obj)) {
            return false;
        }
        TermsQuery that = (TermsQuery)((Object)obj);
        if (that.hashCode == this.hashCode && this.getBoost() == that.getBoost() && Arrays.equals(this.termsAndFields, that.termsAndFields) && ArrayUtil.equals((int[])this.offsets, (int)0, (int[])that.offsets, (int)0, (int)((lastOffset = this.termsAndFields[this.termsAndFields.length - 1].end) + 1))) {
            return ArrayUtil.equals((byte[])this.termsBytes, (int)0, (byte[])that.termsBytes, (int)0, (int)this.offsets[lastOffset]);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.hashCode;
    }

    public String toString(String defaultField) {
        StringBuilder builder = new StringBuilder();
        BytesRef spare = new BytesRef(this.termsBytes);
        boolean first = true;
        for (int i = 0; i < this.termsAndFields.length; ++i) {
            TermsAndField current = this.termsAndFields[i];
            for (int j = current.start; j < current.end; ++j) {
                spare.offset = this.offsets[j];
                spare.length = this.offsets[j + 1] - this.offsets[j];
                if (!first) {
                    builder.append(' ');
                }
                first = false;
                builder.append(current.field).append(':');
                builder.append(spare.utf8ToString());
            }
        }
        builder.append(ToStringUtils.boost((float)this.getBoost()));
        return builder.toString();
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((Accountable[])this.termsAndFields) + RamUsageEstimator.sizeOf((byte[])this.termsBytes) + RamUsageEstimator.sizeOf((int[])this.offsets);
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    private static <T extends Comparable<? super T>> List<T> sort(List<T> toSort) {
        if (toSort.isEmpty()) {
            throw new IllegalArgumentException("no terms provided");
        }
        Collections.sort(toSort);
        return toSort;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new Weight(this){
            private float queryNorm;
            private float queryWeight;

            public float getValueForNormalization() throws IOException {
                this.queryWeight = TermsQuery.this.getBoost();
                return this.queryWeight * this.queryWeight;
            }

            public void normalize(float norm, float topLevelBoost) {
                this.queryNorm = norm * topLevelBoost;
                this.queryWeight *= this.queryNorm;
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Scorer s = this.scorer(context, context.reader().getLiveDocs());
                boolean exists = s != null && s.advance(doc) == doc;
                ComplexExplanation result = new ComplexExplanation();
                if (exists) {
                    result.setDescription(TermsQuery.this.toString() + ", product of:");
                    result.setValue(this.queryWeight);
                    result.setMatch(Boolean.TRUE);
                    result.addDetail(new Explanation(TermsQuery.this.getBoost(), "boost"));
                    result.addDetail(new Explanation(this.queryNorm, "queryNorm"));
                } else {
                    result.setDescription(TermsQuery.this.toString() + " doesn't match id " + doc);
                    result.setValue(0.0f);
                    result.setMatch(Boolean.FALSE);
                }
                return result;
            }

            public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
                LeafReader reader = context.reader();
                BitDocIdSet.Builder builder = new BitDocIdSet.Builder(reader.maxDoc());
                Fields fields = reader.fields();
                BytesRef spare = new BytesRef(TermsQuery.this.termsBytes);
                Terms terms = null;
                TermsEnum termsEnum = null;
                PostingsEnum docs = null;
                for (TermsAndField termsAndField : TermsQuery.this.termsAndFields) {
                    terms = fields.terms(termsAndField.field);
                    if (terms == null) continue;
                    termsEnum = terms.iterator(termsEnum);
                    for (int i = termsAndField.start; i < termsAndField.end; ++i) {
                        spare.offset = TermsQuery.this.offsets[i];
                        spare.length = TermsQuery.this.offsets[i + 1] - TermsQuery.this.offsets[i];
                        if (!termsEnum.seekExact(spare)) continue;
                        docs = termsEnum.postings(acceptDocs, docs, 0);
                        builder.or((DocIdSetIterator)docs);
                    }
                }
                BitDocIdSet result = builder.build();
                if (result == null) {
                    return null;
                }
                final DocIdSetIterator disi = result.iterator();
                return new Scorer(this){

                    public float score() throws IOException {
                        return queryWeight;
                    }

                    public int freq() throws IOException {
                        return 1;
                    }

                    public int docID() {
                        return disi.docID();
                    }

                    public int nextDoc() throws IOException {
                        return disi.nextDoc();
                    }

                    public int advance(int target) throws IOException {
                        return disi.advance(target);
                    }

                    public long cost() {
                        return disi.cost();
                    }
                };
            }
        };
    }

    private static abstract class FieldAndTermEnum {
        protected String field;

        public abstract BytesRef next();

        public FieldAndTermEnum() {
        }

        public FieldAndTermEnum(String field) {
            this.field = field;
        }

        public String field() {
            return this.field;
        }
    }

    private static final class TermsAndField
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(TermsAndField.class) + RamUsageEstimator.shallowSizeOfInstance(String.class) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        final int start;
        final int end;
        final String field;

        TermsAndField(int start, int end, String field) {
            this.start = start;
            this.end = end;
            this.field = field;
        }

        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + (long)(this.field.length() * 2);
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            result = 31 * result + this.end;
            result = 31 * result + this.start;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TermsAndField other = (TermsAndField)obj;
            if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
                return false;
            }
            if (this.end != other.end) {
                return false;
            }
            return this.start == other.start;
        }
    }
}

