/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueInt;

public class IntFieldSource
extends FieldCacheSource {
    public IntFieldSource(String field) {
        super(field);
    }

    @Override
    public String description() {
        return "int(" + this.field + ')';
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final NumericDocValues arr = DocValues.getNumeric((LeafReader)readerContext.reader(), (String)this.field);
        final Bits valid = DocValues.getDocsWithField((LeafReader)readerContext.reader(), (String)this.field);
        return new IntDocValues(this){
            final MutableValueInt val;
            {
                super(x0);
                this.val = new MutableValueInt();
            }

            @Override
            public int intVal(int doc) {
                return (int)arr.get(doc);
            }

            @Override
            public String strVal(int doc) {
                return Integer.toString(this.intVal(doc));
            }

            @Override
            public boolean exists(int doc) {
                return arr.get(doc) != 0L || valid.get(doc);
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueInt mval = new MutableValueInt();

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc) {
                        this.mval.value = this.intVal(doc);
                        this.mval.exists = this.mval.value != 0 || valid.get(doc);
                    }
                };
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != IntFieldSource.class) {
            return false;
        }
        IntFieldSource other = (IntFieldSource)o;
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int h = Integer.class.hashCode();
        return h += super.hashCode();
    }
}

