/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.Cell;
import org.apache.solr.client.solrj.cloud.autoscaling.DelegatingCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.DelegatingClusterStateProvider;
import org.apache.solr.client.solrj.cloud.autoscaling.DelegatingDistribStateManager;
import org.apache.solr.client.solrj.cloud.autoscaling.DistribStateManager;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.Preference;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggestion;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyHelper {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String POLICY_MAPPING_KEY = "PolicyHelper.policyMapping";
    public static final int SESSION_EXPIRY = 180;
    static ThreadLocal<SessionWrapper> SESSION_WRAPPPER_REF = new ThreadLocal();

    private static ThreadLocal<Map<String, String>> getPolicyMapping(SolrCloudManager cloudManager) {
        return (ThreadLocal)cloudManager.getObjectCache().computeIfAbsent(POLICY_MAPPING_KEY, k -> new ThreadLocal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ReplicaPosition> getReplicaLocations(String collName, final AutoScalingConfig autoScalingConfig, SolrCloudManager cloudManager, final Map<String, String> optionalPolicyMapping, List<String> shardNames, int nrtReplicas, int tlogReplicas, int pullReplicas, List<String> nodesList) {
        ArrayList<ReplicaPosition> positions = new ArrayList<ReplicaPosition>();
        final ThreadLocal<Map<String, String>> policyMapping = PolicyHelper.getPolicyMapping(cloudManager);
        final DelegatingClusterStateProvider stateProvider = new DelegatingClusterStateProvider(cloudManager.getClusterStateProvider()){

            @Override
            public String getPolicyNameByCollection(String coll) {
                return policyMapping.get() != null && ((Map)policyMapping.get()).containsKey(coll) ? (String)optionalPolicyMapping.get(coll) : this.delegate.getPolicyNameByCollection(coll);
            }
        };
        DelegatingCloudManager delegatingManager = new DelegatingCloudManager(cloudManager){

            @Override
            public ClusterStateProvider getClusterStateProvider() {
                return stateProvider;
            }

            @Override
            public DistribStateManager getDistribStateManager() {
                if (autoScalingConfig != null) {
                    return new DelegatingDistribStateManager(null){

                        @Override
                        public AutoScalingConfig getAutoScalingConfig() throws InterruptedException, IOException {
                            return autoScalingConfig;
                        }
                    };
                }
                return super.getDistribStateManager();
            }
        };
        policyMapping.set(optionalPolicyMapping);
        SessionWrapper sessionWrapper = null;
        Policy.Session session = null;
        try {
            try {
                sessionWrapper = PolicyHelper.getSession(delegatingManager);
                SESSION_WRAPPPER_REF.set(sessionWrapper);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "unable to get autoscaling policy session", (Throwable)e);
            }
            session = sessionWrapper.session;
            HashMap<String, Double> diskSpaceReqd = new HashMap<String, Double>();
            try {
                DocCollection coll = cloudManager.getClusterStateProvider().getCollection(collName);
                if (coll != null) {
                    for (String shardName : shardNames) {
                        Object idxSz;
                        Map<String, Map<String, List<ReplicaInfo>>> details;
                        ReplicaInfo replicaInfo;
                        Replica ldr = coll.getLeader(shardName);
                        if (ldr == null || (replicaInfo = (ReplicaInfo)(details = cloudManager.getNodeStateProvider().getReplicaInfo(ldr.getNodeName(), Collections.singleton(Suggestion.ConditionType.FREEDISK.perReplicaValue))).getOrDefault(collName, Collections.emptyMap()).getOrDefault(shardName, Collections.singletonList(null)).get(0)) == null || (idxSz = replicaInfo.getVariables().get(Suggestion.ConditionType.FREEDISK.perReplicaValue)) == null) continue;
                        diskSpaceReqd.put(shardName, 1.5 * (Double)Suggestion.ConditionType.FREEDISK.validate(null, idxSz, false));
                    }
                }
            }
            catch (IOException coll) {
                // empty catch block
            }
            EnumMap<Replica.Type, Integer> typeVsCount = new EnumMap<Replica.Type, Integer>(Replica.Type.class);
            typeVsCount.put(Replica.Type.NRT, nrtReplicas);
            typeVsCount.put(Replica.Type.TLOG, tlogReplicas);
            typeVsCount.put(Replica.Type.PULL, pullReplicas);
            for (String shardName : shardNames) {
                int idx = 0;
                for (Map.Entry e : typeVsCount.entrySet()) {
                    for (int i = 0; i < (Integer)e.getValue(); ++i) {
                        SolrRequest op;
                        Suggester suggester = session.getSuggester(CollectionParams.CollectionAction.ADDREPLICA).hint(Suggester.Hint.REPLICATYPE, e.getKey()).hint(Suggester.Hint.COLL_SHARD, new Pair<String, String>(collName, shardName));
                        if (nodesList != null) {
                            for (String nodeName : nodesList) {
                                suggester = suggester.hint(Suggester.Hint.TARGET_NODE, nodeName);
                            }
                        }
                        if (diskSpaceReqd.get(shardName) != null) {
                            suggester.hint(Suggester.Hint.MINFREEDISK, diskSpaceReqd.get(shardName));
                        }
                        if ((op = suggester.getSuggestion()) == null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No node can satisfy the rules " + Utils.toJSONString(Utils.getDeepCopy(session.expandedClauses, 4, true)));
                        }
                        session = suggester.getSession();
                        positions.add(new ReplicaPosition(shardName, ++idx, (Replica.Type)((Object)e.getKey()), op.getParams().get("node")));
                    }
                }
            }
            policyMapping.remove();
            if (sessionWrapper != null) {
                sessionWrapper.returnSession(session);
            }
        }
        catch (Throwable throwable) {
            policyMapping.remove();
            if (sessionWrapper != null) {
                sessionWrapper.returnSession(session);
            }
            throw throwable;
        }
        return positions;
    }

    public static MapWriter getDiagnostics(Policy policy, SolrCloudManager cloudManager) {
        Policy.Session session = policy.createSession(cloudManager);
        List<Row> sorted = session.getSorted();
        List<Violation> violations = session.getViolations();
        List<Preference> clusterPreferences = policy.getClusterPreferences();
        ArrayList<Map<String, Object>> sortedNodes = new ArrayList<Map<String, Object>>(sorted.size());
        for (Row row : sorted) {
            Map<String, Object> map = Utils.makeMap("node", row.node);
            block1: for (Cell cell : row.getCells()) {
                for (Preference clusterPreference : clusterPreferences) {
                    Policy.SortParam name = clusterPreference.getName();
                    if (!cell.getName().equalsIgnoreCase(name.name())) continue;
                    map.put(name.name(), cell.getValue());
                    continue block1;
                }
            }
            sortedNodes.add(map);
        }
        return ew -> {
            ew.put("sortedNodes", sortedNodes);
            ew.put("violations", violations);
        };
    }

    public static List<Suggester.SuggestionInfo> getSuggestions(AutoScalingConfig autoScalingConf, SolrCloudManager cloudManager) {
        Policy policy = autoScalingConf.getPolicy();
        Suggestion.SuggestionCtx suggestionCtx = new Suggestion.SuggestionCtx();
        suggestionCtx.session = policy.createSession(cloudManager);
        List<Violation> violations = suggestionCtx.session.getViolations();
        for (Violation violation : violations) {
            Suggestion.ConditionType tagType = Suggestion.getTagType(violation.getClause().isPerCollectiontag() ? violation.getClause().tag.name : violation.getClause().globalTag.name);
            tagType.getSuggestions(suggestionCtx.setViolation(violation));
            suggestionCtx.violation = null;
        }
        return suggestionCtx.getSuggestions();
    }

    public static void logState(SolrCloudManager cloudManager, Suggester suggester) {
        if (log.isTraceEnabled()) {
            log.trace("LOGSTATE: {}", (Object)Utils.toJSONString(ew -> {
                ew.put("liveNodes", cloudManager.getClusterStateProvider().getLiveNodes());
                ew.put("suggester", suggester);
                if (suggester.session.nodeStateProvider instanceof MapWriter) {
                    MapWriter nodeStateProvider = (MapWriter)((Object)suggester.session.nodeStateProvider);
                    nodeStateProvider.writeMap(ew);
                }
                try {
                    ew.put("autoscalingJson", cloudManager.getDistribStateManager().getAutoScalingConfig());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }));
        }
    }

    public static SessionWrapper getSession(SolrCloudManager cloudManager) throws IOException, InterruptedException {
        SessionRef sessionRef = (SessionRef)cloudManager.getObjectCache().computeIfAbsent(SessionRef.class.getName(), s -> new SessionRef());
        return sessionRef.get(cloudManager);
    }

    public static SessionWrapper getLastSessionWrapper(boolean clear) {
        SessionWrapper wrapper = SESSION_WRAPPPER_REF.get();
        if (clear) {
            SESSION_WRAPPPER_REF.remove();
        }
        return wrapper;
    }

    public static class SessionWrapper {
        public static final SessionWrapper DEF_INST = new SessionWrapper(null, null);
        private long createTime;
        private long lastUpdateTime;
        private Policy.Session session;
        public Status status;
        private final SessionRef ref;
        private AtomicInteger refCount = new AtomicInteger();

        public long getCreateTime() {
            return this.createTime;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public SessionWrapper(Policy.Session session, SessionRef ref) {
            this.createTime = session != null ? session.cloudManager.getTimeSource().getTime() : TimeSource.NANO_TIME.getTime();
            this.lastUpdateTime = this.createTime;
            this.session = session;
            this.status = Status.UNUSED;
            this.ref = ref;
        }

        public Policy.Session get() {
            return this.session;
        }

        public SessionWrapper update(Policy.Session session) {
            this.lastUpdateTime = session != null ? session.cloudManager.getTimeSource().getTime() : TimeSource.NANO_TIME.getTime();
            this.session = session;
            return this;
        }

        public int getRefCount() {
            return this.refCount.get();
        }

        public void returnSession(Policy.Session session) {
            this.update(session);
            this.refCount.incrementAndGet();
            this.ref.returnSession(this);
        }

        public void release() {
            this.refCount.decrementAndGet();
            this.ref.release(this);
        }

        static {
            SessionWrapper.DEF_INST.status = Status.NULL;
            SessionWrapper.DEF_INST.createTime = -1L;
            SessionWrapper.DEF_INST.lastUpdateTime = -1L;
        }
    }

    static class SessionRef {
        private final Object lockObj = new Object();
        private SessionWrapper sessionWrapper = SessionWrapper.DEF_INST;

        SessionWrapper getSessionWrapper() {
            return this.sessionWrapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void release(SessionWrapper sessionWrapper) {
            Object object = this.lockObj;
            synchronized (object) {
                if (sessionWrapper.createTime == this.sessionWrapper.createTime && this.sessionWrapper.refCount.get() <= 0) {
                    log.debug("session set to NULL");
                    this.sessionWrapper = SessionWrapper.DEF_INST;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void returnSession(SessionWrapper sessionWrapper) {
            TimeSource timeSource = sessionWrapper.session != null ? ((SessionWrapper)sessionWrapper).session.cloudManager.getTimeSource() : TimeSource.NANO_TIME;
            Object object = this.lockObj;
            synchronized (object) {
                sessionWrapper.status = Status.EXECUTING;
                log.info("returnSession, curr-time {} sessionWrapper.createTime {}, this.sessionWrapper.createTime {} ", new Object[]{Utils.time(timeSource, TimeUnit.MILLISECONDS), sessionWrapper.createTime, this.sessionWrapper.createTime});
                if (sessionWrapper.createTime == this.sessionWrapper.createTime) {
                    this.sessionWrapper = sessionWrapper;
                    this.lockObj.notify();
                } else {
                    log.info("create time NOT SAME {} ", (Object)SessionWrapper.DEF_INST.createTime);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SessionWrapper get(SolrCloudManager cloudManager) throws IOException, InterruptedException {
            TimeSource timeSource = cloudManager.getTimeSource();
            Object object = this.lockObj;
            synchronized (object) {
                if (this.sessionWrapper.status == Status.NULL || TimeUnit.SECONDS.convert(timeSource.getTime() - this.sessionWrapper.lastUpdateTime, TimeUnit.NANOSECONDS) > 180L) {
                    return this.createSession(cloudManager);
                }
                long waitStart = Utils.time(timeSource, TimeUnit.MILLISECONDS);
                log.debug("reusing a session {}", (Object)this.sessionWrapper.createTime);
                if (this.sessionWrapper.status == Status.UNUSED || this.sessionWrapper.status == Status.EXECUTING) {
                    this.sessionWrapper.status = Status.COMPUTING;
                    return this.sessionWrapper;
                }
                log.debug("session being used. waiting... current time {} ", (Object)Utils.time(timeSource, TimeUnit.MILLISECONDS));
                try {
                    this.lockObj.wait(10000L);
                }
                catch (InterruptedException e) {
                    log.info("interrupted... ");
                }
                log.debug("out of waiting curr-time:{} time-elapsed {}", (Object)Utils.time(timeSource, TimeUnit.MILLISECONDS), (Object)Utils.timeElapsed(timeSource, waitStart, TimeUnit.MILLISECONDS));
                if (this.sessionWrapper.status == Status.UNUSED || this.sessionWrapper.status == Status.EXECUTING) {
                    log.debug("Wait over. reusing the existing session ");
                    this.sessionWrapper.status = Status.COMPUTING;
                    return this.sessionWrapper;
                }
                return this.createSession(cloudManager);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SessionWrapper createSession(SolrCloudManager cloudManager) throws InterruptedException, IOException {
            Object object = this.lockObj;
            synchronized (object) {
                log.debug("Creating a new session");
                Policy.Session session = cloudManager.getDistribStateManager().getAutoScalingConfig().getPolicy().createSession(cloudManager);
                log.debug("New session created ");
                this.sessionWrapper = new SessionWrapper(session, this);
                this.sessionWrapper.status = Status.COMPUTING;
                return this.sessionWrapper;
            }
        }
    }

    public static enum Status {
        NULL,
        UNUSED,
        COMPUTING,
        EXECUTING;

    }
}

