/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.cloud.DistributedQueueFactory;
import org.apache.solr.client.solrj.cloud.autoscaling.DistribStateManager;
import org.apache.solr.client.solrj.cloud.autoscaling.NodeStateProvider;
import org.apache.solr.client.solrj.cloud.autoscaling.SolrCloudManager;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.SolrClientNodeStateProvider;
import org.apache.solr.client.solrj.impl.ZkDistribStateManager;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.ObjectCache;
import org.apache.solr.common.util.TimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClientCloudManager
implements SolrCloudManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CloudSolrClient solrClient;
    private final ZkDistribStateManager stateManager;
    private final DistributedQueueFactory queueFactory;
    private final ZkStateReader zkStateReader;
    private final SolrZkClient zkClient;
    private final ObjectCache objectCache;
    private volatile boolean isClosed;
    private static final byte[] EMPTY = new byte[0];

    public SolrClientCloudManager(DistributedQueueFactory queueFactory, CloudSolrClient solrClient) {
        this.queueFactory = queueFactory;
        this.solrClient = solrClient;
        this.zkStateReader = solrClient.getZkStateReader();
        this.zkClient = this.zkStateReader.getZkClient();
        this.stateManager = new ZkDistribStateManager(this.zkClient);
        this.isClosed = false;
        this.objectCache = new ObjectCache();
    }

    @Override
    public void close() {
        this.isClosed = true;
        IOUtils.closeQuietly(this.objectCache);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public ObjectCache getObjectCache() {
        return this.objectCache;
    }

    @Override
    public TimeSource getTimeSource() {
        return TimeSource.NANO_TIME;
    }

    @Override
    public ClusterStateProvider getClusterStateProvider() {
        return this.solrClient.getClusterStateProvider();
    }

    @Override
    public NodeStateProvider getNodeStateProvider() {
        return new SolrClientNodeStateProvider(this.solrClient);
    }

    @Override
    public DistribStateManager getDistribStateManager() {
        return this.stateManager;
    }

    @Override
    public SolrResponse request(SolrRequest req) throws IOException {
        try {
            return req.process(this.solrClient);
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] httpRequest(String url, SolrRequest.METHOD method, Map<String, String> headers, String payload, int timeout, boolean followRedirects) throws IOException {
        HttpGet req;
        HttpClient client = this.solrClient.getHttpClient();
        StringEntity entity = null;
        if (payload != null) {
            entity = new StringEntity(payload, "UTF-8");
        }
        switch (method) {
            case GET: {
                req = new HttpGet(url);
                break;
            }
            case POST: {
                req = new HttpPost(url);
                if (entity == null) break;
                ((HttpPost)req).setEntity((HttpEntity)entity);
                break;
            }
            case PUT: {
                req = new HttpPut(url);
                if (entity == null) break;
                ((HttpPut)req).setEntity((HttpEntity)entity);
                break;
            }
            case DELETE: {
                req = new HttpDelete(url);
                break;
            }
            default: {
                throw new IOException("Unsupported method " + (Object)((Object)method));
            }
        }
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> SolrClientCloudManager.lambda$httpRequest$0((HttpRequestBase)req, arg_0, arg_1));
        }
        RequestConfig.Builder requestConfigBuilder = HttpClientUtil.createDefaultRequestConfigBuilder();
        if (timeout > 0) {
            requestConfigBuilder.setSocketTimeout(timeout);
            requestConfigBuilder.setConnectTimeout(timeout);
        }
        requestConfigBuilder.setRedirectsEnabled(followRedirects);
        req.setConfig(requestConfigBuilder.build());
        HttpClientContext httpClientRequestContext = HttpClientUtil.createNewHttpClientRequestContext();
        HttpResponse rsp = client.execute((HttpUriRequest)req, (HttpContext)httpClientRequestContext);
        int statusCode = rsp.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new IOException("Error sending request to " + url + ", HTTP response: " + rsp.toString());
        }
        HttpEntity responseEntity = rsp.getEntity();
        if (responseEntity != null && responseEntity.getContent() != null) {
            return EntityUtils.toByteArray((HttpEntity)responseEntity);
        }
        return EMPTY;
    }

    @Override
    public DistributedQueueFactory getDistributedQueueFactory() {
        return this.queueFactory;
    }

    private static /* synthetic */ void lambda$httpRequest$0(HttpRequestBase req, String k, String v) {
        req.addHeader(k, v);
    }
}

