/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.Utils;

public class CollectionApiMapping {
    private static Collection<String> getParamNames_(CommandOperation op, CommandMeta command) {
        Object o = op.getCommandData();
        if (o instanceof Map) {
            Map map = (Map)o;
            ArrayList<String> result = new ArrayList<String>();
            CollectionApiMapping.collectKeyNames(map, result, "");
            return result;
        }
        return Collections.emptySet();
    }

    public static void collectKeyNames(Map<String, Object> map, List<String> result, String prefix) {
        for (Map.Entry<String, Object> e : map.entrySet()) {
            if (e.getValue() instanceof Map) {
                CollectionApiMapping.collectKeyNames((Map)e.getValue(), result, prefix + e.getKey() + ".");
                continue;
            }
            result.add(prefix + e.getKey());
        }
    }

    public static interface CommandMeta {
        public String getName();

        public SolrRequest.METHOD getHttpMethod();

        public V2EndPoint getEndPoint();

        default public Iterator<String> getParamNamesIterator(CommandOperation op) {
            return CollectionApiMapping.getParamNames_(op, this).iterator();
        }

        default public String getParamSubstitute(String name) {
            return name;
        }
    }

    public static enum ConfigSetEndPoint implements V2EndPoint
    {
        LIST_CONFIG("cluster.configs"),
        CONFIG_COMMANDS("cluster.configs.Commands"),
        CONFIG_DEL("cluster.configs.delete");

        public final String spec;

        private ConfigSetEndPoint(String spec) {
            this.spec = spec;
        }

        @Override
        public String getSpecName() {
            return this.spec;
        }
    }

    public static enum ConfigSetMeta implements CommandMeta
    {
        LIST(ConfigSetEndPoint.LIST_CONFIG, SolrRequest.METHOD.GET, null, ConfigSetParams.ConfigSetAction.LIST),
        CREATE(ConfigSetEndPoint.CONFIG_COMMANDS, SolrRequest.METHOD.POST, "create", ConfigSetParams.ConfigSetAction.CREATE),
        DEL(ConfigSetEndPoint.CONFIG_DEL, SolrRequest.METHOD.DELETE, null, ConfigSetParams.ConfigSetAction.DELETE);

        public final ConfigSetEndPoint endPoint;
        public final SolrRequest.METHOD method;
        public final String cmdName;
        public final ConfigSetParams.ConfigSetAction action;

        private ConfigSetMeta(ConfigSetEndPoint endPoint, SolrRequest.METHOD method, String cmdName, ConfigSetParams.ConfigSetAction action) {
            this.cmdName = cmdName;
            this.endPoint = endPoint;
            this.method = method;
            this.action = action;
        }

        @Override
        public String getName() {
            return this.cmdName;
        }

        @Override
        public SolrRequest.METHOD getHttpMethod() {
            return this.method;
        }

        @Override
        public V2EndPoint getEndPoint() {
            return this.endPoint;
        }
    }

    public static interface V2EndPoint {
        public String getSpecName();
    }

    public static enum EndPoint implements V2EndPoint
    {
        CLUSTER("cluster"),
        CLUSTER_ALIASES("cluster.aliases"),
        CLUSTER_CMD("cluster.Commands"),
        CLUSTER_NODES("cluster.nodes"),
        CLUSTER_CMD_STATUS("cluster.commandstatus"),
        CLUSTER_CMD_STATUS_DELETE("cluster.commandstatus.delete"),
        COLLECTIONS_COMMANDS("collections.Commands"),
        COLLECTIONS("collections"),
        COLLECTION_STATE("collections.collection"),
        PER_COLLECTION("collections.collection.Commands"),
        PER_COLLECTION_DELETE("collections.collection.delete"),
        PER_COLLECTION_SHARDS_COMMANDS("collections.collection.shards.Commands"),
        PER_COLLECTION_PER_SHARD_COMMANDS("collections.collection.shards.shard.Commands"),
        PER_COLLECTION_PER_SHARD_DELETE("collections.collection.shards.shard.delete"),
        PER_COLLECTION_PER_SHARD_PER_REPLICA_DELETE("collections.collection.shards.shard.replica.delete");

        final String specName;

        private EndPoint(String specName) {
            this.specName = specName;
        }

        @Override
        public String getSpecName() {
            return this.specName;
        }
    }

    public static enum Meta implements CommandMeta
    {
        GET_COLLECTIONS(EndPoint.COLLECTIONS, SolrRequest.METHOD.GET, CollectionParams.CollectionAction.LIST),
        GET_CLUSTER(EndPoint.CLUSTER, SolrRequest.METHOD.GET, CollectionParams.CollectionAction.LIST, "/cluster", null),
        GET_CLUSTER_OVERSEER(EndPoint.CLUSTER, SolrRequest.METHOD.GET, CollectionParams.CollectionAction.OVERSEERSTATUS, "/cluster/overseer", null),
        GET_CLUSTER_STATUS_CMD(EndPoint.CLUSTER_CMD_STATUS, SolrRequest.METHOD.GET, CollectionParams.CollectionAction.REQUESTSTATUS),
        DELETE_CLUSTER_STATUS(EndPoint.CLUSTER_CMD_STATUS_DELETE, SolrRequest.METHOD.DELETE, CollectionParams.CollectionAction.DELETESTATUS),
        GET_A_COLLECTION(EndPoint.COLLECTION_STATE, SolrRequest.METHOD.GET, CollectionParams.CollectionAction.CLUSTERSTATUS),
        LIST_ALIASES(EndPoint.CLUSTER_ALIASES, SolrRequest.METHOD.GET, CollectionParams.CollectionAction.LISTALIASES),
        CREATE_COLLECTION(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.CREATE, CollectionParams.CollectionAction.CREATE.toLower(), Utils.makeMap("collection.configName", "config", "createNodeSet.shuffle", "shuffleNodes", "createNodeSet", "nodeSet"), Utils.makeMap("property.", "properties.")),
        DELETE_COLL(EndPoint.PER_COLLECTION_DELETE, SolrRequest.METHOD.DELETE, CollectionParams.CollectionAction.DELETE, CollectionParams.CollectionAction.DELETE.toLower(), Utils.makeMap("name", "collection")),
        RELOAD_COLL(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.RELOAD, CollectionParams.CollectionAction.RELOAD.toLower(), Utils.makeMap("name", "collection")),
        MODIFY_COLLECTION(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.MODIFYCOLLECTION, "modify", null),
        MIGRATE_DOCS(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.MIGRATE, "migrate-docs", Utils.makeMap("split.key", "splitKey", "target.collection", "target", "forward.timeout", "forwardTimeout")),
        MOVE_REPLICA(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.MOVEREPLICA, "move-replica", null),
        REBALANCE_LEADERS(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.REBALANCELEADERS, "rebalance-leaders", null),
        CREATE_ALIAS(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.CREATEALIAS, "create-alias", Meta.CREATE_COLLECTION.paramsToAttrs.entrySet().stream().collect(Collectors.toMap(entry -> "create-collection." + (String)entry.getKey(), entry -> "create-collection." + (String)entry.getValue())), Meta.CREATE_COLLECTION.prefixParamsToAttrs.entrySet().stream().collect(Collectors.toMap(entry -> "create-collection." + (String)entry.getKey(), entry -> "create-collection." + (String)entry.getValue()))),
        DELETE_ALIAS(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.DELETEALIAS, "delete-alias", null),
        ALIAS_PROP(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.ALIASPROP, "set-alias-property", null, Utils.makeMap("property.", "properties.")),
        CREATE_SHARD(EndPoint.PER_COLLECTION_SHARDS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.CREATESHARD, "create", Utils.makeMap("createNodeSet", "nodeSet"), Utils.makeMap("property.", "coreProperties.")){

            @Override
            public String getParamSubstitute(String param) {
                return super.getParamSubstitute(param);
            }
        }
        ,
        SPLIT_SHARD(EndPoint.PER_COLLECTION_SHARDS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.SPLITSHARD, "split", Utils.makeMap("split.key", "splitKey"), Utils.makeMap("property.", "coreProperties.")),
        DELETE_SHARD(EndPoint.PER_COLLECTION_PER_SHARD_DELETE, SolrRequest.METHOD.DELETE, CollectionParams.CollectionAction.DELETESHARD),
        CREATE_REPLICA(EndPoint.PER_COLLECTION_SHARDS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.ADDREPLICA, "add-replica", null, Utils.makeMap("property.", "coreProperties.")),
        DELETE_REPLICA(EndPoint.PER_COLLECTION_PER_SHARD_PER_REPLICA_DELETE, SolrRequest.METHOD.DELETE, CollectionParams.CollectionAction.DELETEREPLICA),
        SYNC_SHARD(EndPoint.PER_COLLECTION_PER_SHARD_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.SYNCSHARD, "synch-shard", null),
        ADD_REPLICA_PROPERTY(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.ADDREPLICAPROP, "add-replica-property", Utils.makeMap("property", "name", "property.value", "value")),
        DELETE_REPLICA_PROPERTY(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.DELETEREPLICAPROP, "delete-replica-property", null),
        SET_COLLECTION_PROPERTY(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.COLLECTIONPROP, "set-collection-property", Utils.makeMap("name", "collection", "propertyName", "name", "propertyValue", "value")),
        ADD_ROLE(EndPoint.CLUSTER_CMD, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.ADDROLE, "add-role", null),
        REMOVE_ROLE(EndPoint.CLUSTER_CMD, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.REMOVEROLE, "remove-role", null),
        SET_CLUSTER_PROPERTY(EndPoint.CLUSTER_CMD, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.CLUSTERPROP, "set-property", null),
        UTILIZE_NODE(EndPoint.CLUSTER_CMD, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.UTILIZENODE, "utilize-node", null),
        BACKUP_COLLECTION(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.BACKUP, "backup-collection", null),
        RESTORE_COLLECTION(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.RESTORE, "restore-collection", null),
        GET_NODES(EndPoint.CLUSTER_NODES, SolrRequest.METHOD.GET, null),
        FORCE_LEADER(EndPoint.PER_COLLECTION_PER_SHARD_COMMANDS, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.FORCELEADER, "force-leader", null),
        BALANCE_SHARD_UNIQUE(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionParams.CollectionAction.BALANCESHARDUNIQUE, "balance-shard-unique", null);

        public final String commandName;
        public final EndPoint endPoint;
        public final SolrRequest.METHOD method;
        public final CollectionParams.CollectionAction action;
        public final Map<String, String> paramsToAttrs;
        public final Map<String, String> attrsToParams;
        public final Map<String, String> prefixParamsToAttrs;

        public SolrRequest.METHOD getMethod() {
            return this.method;
        }

        private Meta(EndPoint endPoint, SolrRequest.METHOD method, CollectionParams.CollectionAction action) {
            this(endPoint, method, action, null, null);
        }

        private Meta(EndPoint endPoint, SolrRequest.METHOD method, CollectionParams.CollectionAction action, String commandName, Map paramsToAttrs) {
            this(endPoint, method, action, commandName, paramsToAttrs, Collections.emptyMap());
        }

        private Meta(EndPoint endPoint, SolrRequest.METHOD method, CollectionParams.CollectionAction action, String commandName, Map paramsToAttrs, Map prefixParamsToAttrs) {
            this.action = action;
            this.commandName = commandName;
            this.endPoint = endPoint;
            this.method = method;
            this.paramsToAttrs = paramsToAttrs == null ? Collections.emptyMap() : Collections.unmodifiableMap(paramsToAttrs);
            this.attrsToParams = Collections.unmodifiableMap(Meta.reverseMap(this.paramsToAttrs));
            this.prefixParamsToAttrs = prefixParamsToAttrs == null ? Collections.emptyMap() : Collections.unmodifiableMap(prefixParamsToAttrs);
        }

        private static Map<String, String> reverseMap(Map<String, String> input) {
            HashMap<String, String> attrToParams = new HashMap<String, String>(input.size());
            for (Map.Entry<String, String> entry : input.entrySet()) {
                String existing = attrToParams.put(entry.getValue(), entry.getKey());
                if (existing == null) continue;
                throw new IllegalArgumentException("keys and values must collectively be unique");
            }
            return attrToParams;
        }

        @Override
        public String getName() {
            return this.commandName;
        }

        @Override
        public SolrRequest.METHOD getHttpMethod() {
            return this.method;
        }

        @Override
        public V2EndPoint getEndPoint() {
            return this.endPoint;
        }

        @Override
        public Iterator<String> getParamNamesIterator(CommandOperation op) {
            Collection paramNames = CollectionApiMapping.getParamNames_(op, this);
            Stream<Object> pStream = paramNames.stream();
            if (!this.attrsToParams.isEmpty()) {
                pStream = pStream.map(paramName -> this.attrsToParams.getOrDefault(paramName, (String)paramName));
            }
            if (!this.prefixParamsToAttrs.isEmpty()) {
                pStream = pStream.map(paramName -> {
                    for (Map.Entry<String, String> e : this.prefixParamsToAttrs.entrySet()) {
                        String prefixV1 = e.getKey();
                        String prefixV2 = e.getValue();
                        if (!paramName.startsWith(prefixV2)) continue;
                        return prefixV1 + paramName.substring(prefixV2.length());
                    }
                    return paramName;
                });
            }
            return pStream.iterator();
        }

        @Override
        public String getParamSubstitute(String param) {
            for (Map.Entry<String, String> e : this.prefixParamsToAttrs.entrySet()) {
                String prefixV1 = e.getKey();
                String prefixV2 = e.getValue();
                if (!param.startsWith(prefixV1)) continue;
                return prefixV2 + param.substring(prefixV1.length());
            }
            return this.paramsToAttrs.getOrDefault(param, param);
        }

        public Object getReverseParamSubstitute(String param) {
            for (Map.Entry<String, String> e : this.prefixParamsToAttrs.entrySet()) {
                String prefixV1 = e.getKey();
                String prefixV2 = e.getValue();
                if (!param.startsWith(prefixV1)) continue;
                return new Pair<String, String>(prefixV2.substring(0, prefixV2.length() - 1), param.substring(prefixV1.length()));
            }
            return this.paramsToAttrs.getOrDefault(param, param);
        }
    }
}

