/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.util.SuppressForbidden;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeSource {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final TimeSource CURRENT_TIME = new CurrentTimeSource();
    public static final TimeSource NANO_TIME = new NanoTimeSource();
    private static Map<String, SimTimeSource> simTimeSources = new ConcurrentHashMap<String, SimTimeSource>();

    public static TimeSource get(String type) {
        if (type == null) {
            return NANO_TIME;
        }
        if (type.equals("currentTime")) {
            return CURRENT_TIME;
        }
        if (type.equals("nanoTime")) {
            return NANO_TIME;
        }
        if (type.startsWith("simTime")) {
            return simTimeSources.computeIfAbsent(type, t -> {
                String[] parts = t.split(":");
                double mul = 1.0;
                if (parts.length != 2) {
                    log.warn("Invalid simTime specification, assuming multiplier==1.0: '" + type + "'");
                } else {
                    try {
                        mul = Double.parseDouble(parts[1]);
                    }
                    catch (Exception e) {
                        log.warn("Invalid simTime specification, assuming multiplier==1.0: '" + type + "'");
                    }
                }
                return new SimTimeSource(mul);
            });
        }
        throw new UnsupportedOperationException("Unsupported time source type '" + type + "'.");
    }

    public abstract long getTime();

    public abstract void sleep(long var1) throws InterruptedException;

    public abstract long convertDelay(TimeUnit var1, long var2, TimeUnit var4);

    public static final class SimTimeSource
    extends TimeSource {
        final double multiplier;
        long start;

        public SimTimeSource(double multiplier) {
            this.multiplier = multiplier;
            this.start = NANO_TIME.getTime();
        }

        public void advance(long delta) {
            this.start = this.getTime() + delta;
        }

        @Override
        public long getTime() {
            return this.start + Math.round((double)(NANO_TIME.getTime() - this.start) * this.multiplier);
        }

        @Override
        public void sleep(long ms) throws InterruptedException {
            ms = Math.round((double)ms / this.multiplier);
            Thread.sleep(ms);
        }

        @Override
        public long convertDelay(TimeUnit fromUnit, long value, TimeUnit toUnit) {
            long nano = Math.round((double)TimeUnit.NANOSECONDS.convert(value, fromUnit) / this.multiplier);
            return toUnit.convert(nano, TimeUnit.NANOSECONDS);
        }
    }

    public static final class NanoTimeSource
    extends TimeSource {
        @Override
        public long getTime() {
            return System.nanoTime();
        }

        @Override
        public void sleep(long ms) throws InterruptedException {
            Thread.sleep(ms);
        }

        @Override
        public long convertDelay(TimeUnit fromUnit, long value, TimeUnit toUnit) {
            return toUnit.convert(value, fromUnit);
        }
    }

    public static final class CurrentTimeSource
    extends TimeSource {
        @Override
        @SuppressForbidden(reason="Needed to provide timestamps based on currentTimeMillis.")
        public long getTime() {
            return TimeUnit.NANOSECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public void sleep(long ms) throws InterruptedException {
            Thread.sleep(ms);
        }

        @Override
        public long convertDelay(TimeUnit fromUnit, long value, TimeUnit toUnit) {
            return toUnit.convert(value, fromUnit);
        }
    }
}

