/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="reserve-network-port", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, threadSafe=true)
public class ReserveListenerPortMojo
extends AbstractMojo {
    private static final String BUILD_HELPER_RESERVED_PORTS = "BUILD_HELPER_MIN_PORT";
    private static final Integer FIRST_NON_ROOT_PORT_NUMBER = 1024;
    private static final Integer MAX_PORT_NUMBER = 65536;
    private static final Object lock = new Object();
    @Parameter(required=true)
    private final String[] portNames = new String[0];
    @Parameter
    private File outputFile;
    @Parameter
    private Integer minPortNumber;
    @Parameter
    private Integer maxPortNumber;
    @Parameter
    private boolean randomPort;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        block16: {
            Properties properties = this.project.getProperties();
            if (this.outputFile != null) {
                properties = new Properties();
            }
            ArrayList<ServerSocket> sockets = new ArrayList<ServerSocket>();
            try {
                for (String portName : this.portNames) {
                    try {
                        ServerSocket socket = this.getServerSocket();
                        sockets.add(socket);
                        String unusedPort = Integer.toString(socket.getLocalPort());
                        properties.put(portName, unusedPort);
                        this.getReservedPorts().add(socket.getLocalPort());
                        this.getLog().info((CharSequence)("Reserved port " + unusedPort + " for " + portName));
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error getting an available port from system", (Exception)e);
                    }
                }
                if (this.outputFile == null) break block16;
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(this.outputFile);
                    properties.store(os, null);
                }
                catch (Exception e) {
                    try {
                        throw new MojoExecutionException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(os);
                        throw throwable;
                    }
                }
                IOUtil.close((OutputStream)os);
            }
            finally {
                for (ServerSocket socket : sockets) {
                    int localPort = socket.getLocalPort();
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        this.getLog().error((CharSequence)("Cannot free reserved port " + localPort));
                    }
                }
            }
        }
    }

    private ServerSocket getServerSocket() throws IOException, MojoExecutionException {
        if (this.minPortNumber == null && this.maxPortNumber != null) {
            this.getLog().debug((CharSequence)("minPortNumber unspecified: using default value " + FIRST_NON_ROOT_PORT_NUMBER));
            this.minPortNumber = FIRST_NON_ROOT_PORT_NUMBER;
        }
        if (this.minPortNumber != null && this.maxPortNumber == null) {
            this.getLog().debug((CharSequence)("maxPortNumber unspecified: using default value " + MAX_PORT_NUMBER));
            this.maxPortNumber = MAX_PORT_NUMBER;
        }
        if (this.minPortNumber == null && this.maxPortNumber == null) {
            return new ServerSocket(0);
        }
        if (this.randomPort) {
            Object object = lock;
            synchronized (object) {
                List<Integer> availablePorts = this.randomPortList();
                Iterator<Integer> iterator = availablePorts.iterator();
                while (iterator.hasNext()) {
                    int port = iterator.next();
                    ServerSocket serverSocket = this.reservePort(port);
                    iterator.remove();
                    if (serverSocket == null) continue;
                    return serverSocket;
                }
                throw new MojoExecutionException("Unable to find an available port between " + this.minPortNumber + " and " + this.maxPortNumber);
            }
        }
        Object object = lock;
        synchronized (object) {
            int min;
            int port = min = this.getNextPortNumber();
            while (true) {
                ServerSocket serverSocket;
                if ((serverSocket = this.reservePort(port)) != null) {
                    return serverSocket;
                }
                ++port;
            }
        }
    }

    private List<Integer> randomPortList() {
        int difference = this.maxPortNumber - this.minPortNumber + 1;
        ArrayList<Integer> portList = new ArrayList<Integer>(difference);
        List<Integer> reservedPorts = this.getReservedPorts();
        for (int i = 0; i < difference; ++i) {
            int port = this.minPortNumber + i;
            if (reservedPorts.contains(port)) continue;
            portList.add(this.minPortNumber + i);
        }
        Collections.shuffle(portList);
        return portList;
    }

    public ServerSocket reservePort(int port) throws MojoExecutionException {
        if (port > this.maxPortNumber) {
            throw new MojoExecutionException("Unable to find an available port between " + this.minPortNumber + " and " + this.maxPortNumber);
        }
        try {
            ServerSocket serverSocket = new ServerSocket(port);
            this.getLog().info((CharSequence)("Port assigned" + port));
            return serverSocket;
        }
        catch (IOException ioe) {
            this.getLog().info((CharSequence)("Tried binding to port " + port + " without success. Trying next port."), (Throwable)ioe);
            return null;
        }
    }

    private int getNextPortNumber() {
        assert (this.minPortNumber != null);
        List<Integer> reservedPorts = this.getReservedPorts();
        int nextPort = -1;
        nextPort = reservedPorts.isEmpty() ? this.minPortNumber.intValue() : this.findAvailablePortNumber(this.minPortNumber, reservedPorts);
        reservedPorts.add(nextPort);
        this.getLog().debug((CharSequence)("Next port: " + nextPort));
        return nextPort;
    }

    private List<Integer> getReservedPorts() {
        ArrayList reservedPorts = (ArrayList)this.getPluginContext().get(BUILD_HELPER_RESERVED_PORTS);
        if (reservedPorts == null) {
            reservedPorts = new ArrayList();
            this.getPluginContext().put(BUILD_HELPER_RESERVED_PORTS, reservedPorts);
        }
        return reservedPorts;
    }

    private int findAvailablePortNumber(Integer portNumberStartingPoint, List<Integer> reservedPorts) {
        assert (portNumberStartingPoint != null);
        int candidate = portNumberStartingPoint;
        while (reservedPorts.contains(candidate)) {
            ++candidate;
        }
        return candidate;
    }
}

