/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.charset.UnicodeProperties;
import com.oracle.truffle.regex.charset.UnicodePropertyDataVersion;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.parser.RegexParser;
import com.oracle.truffle.regex.tregex.parser.RegexValidator;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.flavors.PythonRegexParser;
import com.oracle.truffle.regex.tregex.parser.flavors.RegexFlavor;
import com.oracle.truffle.regex.tregex.string.Encodings;
import org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;

public final class PythonFlavor
extends RegexFlavor {
    public static final PythonFlavor INSTANCE = new PythonFlavor();
    public static final UnicodeProperties UNICODE = new UnicodeProperties(UnicodePropertyDataVersion.UNICODE_15_1_0, 0);

    private PythonFlavor() {
        super(765);
    }

    @Override
    public RegexValidator createValidator(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegexParser createParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        return new PythonRegexParser(language, source, compilationBuffer);
    }

    @Override
    public RegexFlavor.EqualsIgnoreCasePredicate getEqualsIgnoreCasePredicate(RegexAST ast) {
        if (ast.getOptions().getEncoding() == Encodings.UTF_32) {
            return (codePointA, codePointB, altMode) -> UCharacter.toLowerCase((int)codePointA) == UCharacter.toLowerCase((int)codePointB);
        }
        assert (ast.getOptions().getEncoding() == Encodings.LATIN_1);
        return (a, b, altMode) -> CaseFoldData.CaseFoldUnfoldAlgorithm.Ascii.getEqualsPredicate().test(a, b);
    }

    @Override
    public CaseFoldData.CaseFoldAlgorithm getCaseFoldAlgorithm(RegexAST ast) {
        throw CompilerDirectives.shouldNotReachHere();
    }
}

