/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.charset.UnicodeProperties;
import com.oracle.truffle.regex.charset.UnicodePropertyData;
import com.oracle.truffle.regex.charset.UnicodePropertyDataVersion;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.flavors.java.JavaASCII;
import com.oracle.truffle.regex.tregex.string.Encodings;
import java.util.Locale;

final class JavaUnicodeProperties {
    private static final JavaUnicodeProperties[] CACHE = new JavaUnicodeProperties[3];
    public static final CodePointSet JAVA_LINE_TERMINATOR = CodePointSet.createNoDedup(10, 10, 13, 13, 133, 133, 8232, 8233);
    public static final CodePointSet DOT = CodePointSet.createNoDedup(0, 9, 11, 12, 14, 132, 134, 8231, 8234, 0x10FFFF);
    public static final CodePointSet DOT_UNIX = CodePointSet.createNoDedup(0, 9, 11, 0x10FFFF);
    static final CodePointSet WHITESPACE = CodePointSet.createNoDedup(9, 13, 28, 32, 5760, 5760, 8192, 8198, 8200, 8202, 8232, 8233, 8287, 8287, 12288, 12288);
    static final CodePointSet ISO_CONTROL = CodePointSet.createNoDedup(0, 31, 127, 159);
    final UnicodeProperties unicode;
    final CodePointSet defined;
    final CodePointSet identifierIgnorable;
    final CodePointSet spaceChar;
    final CodePointSet lowerCase;
    final CodePointSet upperCase;
    final CodePointSet lowerUpperTitleCase;
    final CodePointSet alphabetic;
    final CodePointSet letterOrDigit;
    final CodePointSet javaIdentifierStart;
    final CodePointSet javaIdentifierPart;
    final CodePointSet unicodeIdentifierStart;
    final CodePointSet unicodeIdentifierPart;
    final CodePointSet unicodeLetterOrDigit;
    final CodePointSet blank;
    final CodePointSet graph;
    final CodePointSet whiteSpace;
    final CodePointSet digit;
    final CodePointSet nonDigit;
    final CodePointSet word;
    final CodePointSet nonWord;
    final CodePointSet space;
    final CodePointSet nonSpace;

    private JavaUnicodeProperties(UnicodeProperties unicode) {
        this.unicode = unicode;
        this.defined = unicode.getProperty("General_Category=Unassigned").createInverse(Encodings.UTF_16);
        this.identifierIgnorable = CodePointSet.createNoDedup(0, 8, 14, 27, 127, 159).union(unicode.getProperty("General_Category=Format"));
        this.spaceChar = this.unionOfProperties("General_Category=Space_Separator", "General_Category=Line_Separator", "General_Category=Paragraph_Separator");
        this.lowerCase = this.unionOfProperties("General_Category=Lowercase_Letter", "Other_Lowercase");
        this.upperCase = this.unionOfProperties("General_Category=Uppercase_Letter", "Other_Uppercase");
        this.lowerUpperTitleCase = this.unionOfProperties(this.lowerCase.union(this.upperCase), "General_Category=Titlecase_Letter");
        CodePointSet letterLetterNumber = this.unionOfProperties("General_Category=Letter", "General_Category=Letter_Number");
        this.alphabetic = this.unionOfProperties(letterLetterNumber, "Other_Alphabetic");
        this.letterOrDigit = this.unionOfProperties("General_Category=Letter", "General_Category=Decimal_Number");
        this.javaIdentifierStart = this.unionOfProperties(letterLetterNumber, "General_Category=Currency_Symbol", "General_Category=Connector_Punctuation");
        this.javaIdentifierPart = this.unionOfProperties(this.javaIdentifierStart.union(this.identifierIgnorable), "General_Category=Decimal_Number", "General_Category=Spacing_Mark", "General_Category=Nonspacing_Mark");
        this.unicodeIdentifierStart = this.unionOfProperties(letterLetterNumber, "Other_ID_Start");
        this.unicodeIdentifierPart = this.unionOfProperties(this.unicodeIdentifierStart.union(this.identifierIgnorable), "General_Category=Connector_Punctuation", "General_Category=Decimal_Number", "General_Category=Spacing_Mark", "General_Category=Nonspacing_Mark", "Other_ID_Continue");
        this.unicodeLetterOrDigit = this.unionOfProperties("General_Category=Lowercase_Letter", "General_Category=Uppercase_Letter", "General_Category=Titlecase_Letter", "General_Category=Modifier_Letter", "General_Category=Other_Letter", "General_Category=Decimal_Number");
        this.blank = unicode.getProperty("General_Category=Space_Separator").union(CodePointSet.create(9));
        this.graph = this.unionOfProperties("General_Category=Space_Separator", "General_Category=Line_Separator", "General_Category=Paragraph_Separator", "General_Category=Control", "General_Category=Surrogate", "General_Category=Unassigned").createInverse(Encodings.UTF_16);
        this.whiteSpace = this.unionOfProperties(CodePointSet.createNoDedup(9, 13, 133, 133), "General_Category=Space_Separator", "General_Category=Line_Separator", "General_Category=Paragraph_Separator");
        this.digit = unicode.getProperty("General_Category=Decimal_Number");
        this.nonDigit = this.digit.createInverse(Encodings.UTF_16);
        this.word = this.unionOfProperties(this.alphabetic, "Join_Control", "General_Category=Nonspacing_Mark", "General_Category=Enclosing_Mark", "General_Category=Spacing_Mark", "General_Category=Decimal_Number", "General_Category=Connector_Punctuation");
        this.nonWord = this.word.createInverse(Encodings.UTF_16);
        this.space = unicode.getProperty("WSpace");
        this.nonSpace = this.space.createInverse(Encodings.UTF_16);
    }

    static JavaUnicodeProperties create(RegexOptions options) {
        JavaUnicodeProperties ret;
        int jdkVersion = options.getJavaJDKVersion();
        int cacheIndex = jdkVersion - 21;
        JavaUnicodeProperties cached = CACHE[cacheIndex];
        if (cached != null) {
            return cached;
        }
        UnicodeProperties unicode = new UnicodeProperties(JavaUnicodeProperties.getUnicodePropertyData(jdkVersion), 7);
        JavaUnicodeProperties.CACHE[cacheIndex] = ret = new JavaUnicodeProperties(unicode);
        return ret;
    }

    private static UnicodePropertyData getUnicodePropertyData(int jdkVersion) {
        switch (jdkVersion) {
            case 21: {
                return UnicodePropertyDataVersion.UNICODE_15_0_0;
            }
            case 22: 
            case 23: {
                return UnicodePropertyDataVersion.UNICODE_15_1_0;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private CodePointSet unionOfProperties(String ... properties) {
        return this.unionOfProperties((CodePointSet)null, properties);
    }

    private CodePointSet unionOfProperties(CodePointSet initial, String ... properties) {
        CodePointSetAccumulator acc = new CodePointSetAccumulator();
        if (initial != null) {
            acc.addSet(initial);
        }
        for (String property : properties) {
            acc.addSet(this.unicode.getProperty(property));
        }
        return acc.toCodePointSet();
    }

    CodePointSet getBlock(String name) {
        String normalizedName;
        try {
            normalizedName = Character.UnicodeBlock.forName(name).toString().toLowerCase();
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        if (this.unicode.isSupportedBlock(normalizedName)) {
            return this.unicode.getProperty("blk=" + normalizedName);
        }
        return null;
    }

    CodePointSet getScript(String name) {
        String normalizedName;
        try {
            normalizedName = Character.UnicodeScript.forName(name).toString().toLowerCase();
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        if (this.unicode.isSupportedScript(normalizedName)) {
            return this.unicode.getProperty("sc=" + normalizedName);
        }
        return null;
    }

    CodePointSet forUnicodeProperty(String propName, boolean caseIns) {
        String propNameNormalized = propName.toUpperCase(Locale.ROOT);
        CodePointSet p = this.getUnicodePredicate(propNameNormalized, caseIns);
        if (p != null) {
            return p;
        }
        return this.getPosixPredicate(propNameNormalized, caseIns);
    }

    CodePointSet forPOSIXName(String propName, boolean caseIns) {
        return this.getPosixPredicate(propName.toUpperCase(Locale.ENGLISH), caseIns);
    }

    CodePointSet getProperty(String name, boolean caseIns) {
        return switch (name) {
            case "Lu" -> this.unicode.getProperty("gc=" + (caseIns ? "LC" : "Lu"));
            case "Ll" -> this.unicode.getProperty("gc=" + (caseIns ? "LC" : "Ll"));
            case "Lt" -> this.unicode.getProperty("gc=" + (caseIns ? "LC" : "Lt"));
            case "C", "Cc", "Cf", "Cn", "Co", "Cs", "L", "LC", "Lm", "Lo", "M", "Mc", "Me", "Mn", "N", "Nd", "Nl", "No", "P", "Pc", "Pd", "Pe", "Pf", "Pi", "Po", "Ps", "S", "Sc", "Sk", "Sm", "So", "Z", "Zl", "Zp", "Zs" -> this.unicode.getProperty("gc=" + name);
            case "LD" -> this.unicodeLetterOrDigit;
            case "L1" -> Constants.BYTE_RANGE;
            case "all" -> Constants.DOT_ALL;
            case "ASCII" -> Constants.ASCII_RANGE;
            case "Alnum" -> JavaASCII.ALNUM;
            case "Alpha" -> JavaASCII.ALPHA;
            case "Blank" -> JavaASCII.BLANK;
            case "Cntrl" -> JavaASCII.CNTRL;
            case "Digit" -> CodePointSet.createNoDedup(48, 57);
            case "Graph" -> JavaASCII.GRAPH;
            case "Lower" -> {
                if (caseIns) {
                    yield JavaASCII.ALPHA;
                }
                yield JavaASCII.LOWER;
            }
            case "Print" -> CodePointSet.createNoDedup(32, 126);
            case "Punct" -> JavaASCII.PUNCT;
            case "Space" -> JavaASCII.SPACE;
            case "Upper" -> {
                if (caseIns) {
                    yield JavaASCII.ALPHA;
                }
                yield JavaASCII.UPPER;
            }
            case "XDigit" -> JavaASCII.HEX;
            case "javaLowerCase" -> {
                if (caseIns) {
                    yield this.lowerUpperTitleCase;
                }
                yield this.lowerCase;
            }
            case "javaUpperCase" -> {
                if (caseIns) {
                    yield this.lowerUpperTitleCase;
                }
                yield this.upperCase;
            }
            case "javaTitleCase" -> {
                if (caseIns) {
                    yield this.lowerUpperTitleCase;
                }
                yield this.unicode.getProperty("General_Category=Titlecase_Letter");
            }
            case "javaAlphabetic" -> this.alphabetic;
            case "javaIdeographic" -> this.unicode.getProperty("Ideographic");
            case "javaDigit" -> this.unicode.getProperty("General_Category=Decimal_Number");
            case "javaDefined" -> this.defined;
            case "javaLetter" -> this.unicode.getProperty("General_Category=Letter");
            case "javaLetterOrDigit" -> this.letterOrDigit;
            case "javaJavaIdentifierStart" -> this.javaIdentifierStart;
            case "javaJavaIdentifierPart" -> this.javaIdentifierPart;
            case "javaUnicodeIdentifierStart" -> this.unicodeIdentifierStart;
            case "javaUnicodeIdentifierPart" -> this.unicodeIdentifierPart;
            case "javaIdentifierIgnorable" -> this.identifierIgnorable;
            case "javaSpaceChar" -> this.spaceChar;
            case "javaWhitespace" -> WHITESPACE;
            case "javaISOControl" -> ISO_CONTROL;
            case "javaMirrored" -> this.unicode.getProperty("Bidi_Mirrored");
            default -> null;
        };
    }

    private CodePointSet getPosixPredicate(String name, boolean caseIns) {
        return switch (name) {
            case "ALPHA" -> this.alphabetic;
            case "LOWER" -> {
                if (caseIns) {
                    yield this.lowerUpperTitleCase;
                }
                yield this.lowerCase;
            }
            case "UPPER" -> {
                if (caseIns) {
                    yield this.lowerUpperTitleCase;
                }
                yield this.upperCase;
            }
            case "SPACE" -> this.whiteSpace;
            case "PUNCT" -> this.unicode.getProperty("General_Category=Punctuation");
            case "XDIGIT" -> this.unicode.getProperty("General_Category=Decimal_Number").union(this.unicode.getProperty("Hex_Digit"));
            case "ALNUM" -> this.unicode.getProperty("General_Category=Decimal_Number").union(this.alphabetic);
            case "CNTRL" -> this.unicode.getProperty("General_Category=Control");
            case "DIGIT" -> this.unicode.getProperty("General_Category=Decimal_Number");
            case "BLANK" -> this.blank;
            case "GRAPH" -> this.graph;
            case "PRINT" -> this.graph.union(this.blank).subtract(this.unicode.getProperty("General_Category=Control"), new CompilationBuffer(Encodings.UTF_16));
            default -> null;
        };
    }

    private CodePointSet getUnicodePredicate(String name, boolean caseIns) {
        return switch (name) {
            case "ALPHABETIC" -> this.alphabetic;
            case "ASSIGNED" -> this.defined;
            case "CONTROL" -> this.unicode.getProperty("General_Category=Control");
            case "EMOJI" -> this.unicode.getProperty("Emoji");
            case "EMOJI_PRESENTATION" -> this.unicode.getProperty("EPres");
            case "EMOJI_MODIFIER" -> this.unicode.getProperty("EMod");
            case "EMOJI_MODIFIER_BASE" -> this.unicode.getProperty("EBase");
            case "EMOJI_COMPONENT" -> this.unicode.getProperty("EComp");
            case "EXTENDED_PICTOGRAPHIC" -> this.unicode.getProperty("ExtPict");
            case "HEXDIGIT", "HEX_DIGIT" -> this.unicode.getProperty("General_Category=Decimal_Number").union(this.unicode.getProperty("Hex_Digit"));
            case "IDEOGRAPHIC" -> this.unicode.getProperty("Ideographic");
            case "JOINCONTROL", "JOIN_CONTROL" -> this.unicode.getProperty("Join_Control");
            case "LETTER" -> this.unicode.getProperty("General_Category=Letter");
            case "LOWERCASE" -> {
                if (caseIns) {
                    yield this.lowerUpperTitleCase;
                }
                yield this.lowerCase;
            }
            case "NONCHARACTERCODEPOINT", "NONCHARACTER_CODE_POINT" -> this.unicode.getProperty("Noncharacter_Code_Point");
            case "TITLECASE" -> {
                if (caseIns) {
                    yield this.lowerUpperTitleCase;
                }
                yield this.unicode.getProperty("General_Category=Titlecase_Letter");
            }
            case "PUNCTUATION" -> this.unicode.getProperty("General_Category=Punctuation");
            case "UPPERCASE" -> {
                if (caseIns) {
                    yield this.lowerUpperTitleCase;
                }
                yield this.upperCase;
            }
            case "WHITESPACE", "WHITE_SPACE" -> this.whiteSpace;
            case "WORD" -> this.word;
            default -> null;
        };
    }
}

