/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.ppm;

import java.nio.ByteBuffer;
import org.jcodec.common.JCodecUtil2;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;

public class PPMEncoder {
    public ByteBuffer encodeFrame(Picture picture) {
        if (picture.getColor() != ColorSpace.RGB) {
            throw new IllegalArgumentException("Only RGB image can be stored in PPM");
        }
        ByteBuffer buffer = ByteBuffer.allocate(picture.getWidth() * picture.getHeight() * 3 + 200);
        buffer.put(JCodecUtil2.asciiString("P6 " + picture.getWidth() + " " + picture.getHeight() + " 255\n"));
        byte[][] data = picture.getData();
        for (int i = 0; i < picture.getWidth() * picture.getHeight() * 3; i += 3) {
            buffer.put((byte)(data[0][i + 2] + 128));
            buffer.put((byte)(data[0][i + 1] + 128));
            buffer.put((byte)(data[0][i] + 128));
        }
        buffer.flip();
        return buffer;
    }
}

