/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.Signal;
import jnr.constants.platform.Sysconf;
import jnr.posix.FileStat;
import jnr.posix.Group;
import jnr.posix.LibC;
import jnr.posix.MsgHdr;
import jnr.posix.POSIX;
import jnr.posix.POSIXHandler;
import jnr.posix.Passwd;
import jnr.posix.SignalHandler;
import jnr.posix.SpawnAttribute;
import jnr.posix.SpawnFileAction;
import jnr.posix.Times;
import jnr.posix.util.MethodName;
import jnr.posix.util.ProcessMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CheckedPOSIX
implements POSIX {
    private final POSIX posix;
    private final POSIXHandler handler;

    CheckedPOSIX(POSIX posix, POSIXHandler handler) {
        this.posix = posix;
        this.handler = handler;
    }

    private <T> T unimplementedNull() {
        this.handler.unimplementedError(MethodName.getCallerMethodName());
        return null;
    }

    private int unimplementedInt() {
        this.handler.unimplementedError(MethodName.getCallerMethodName());
        return -1;
    }

    private boolean unimplementedBool() {
        this.handler.unimplementedError(MethodName.getCallerMethodName());
        return false;
    }

    private String unimplementedString() {
        this.handler.unimplementedError(MethodName.getCallerMethodName());
        return null;
    }

    @Override
    public ProcessMaker newProcessMaker(String ... command) {
        try {
            return this.posix.newProcessMaker(command);
        }
        catch (UnsatisfiedLinkError ule) {
            return (ProcessMaker)this.unimplementedNull();
        }
    }

    @Override
    public ProcessMaker newProcessMaker() {
        try {
            return this.posix.newProcessMaker();
        }
        catch (UnsatisfiedLinkError ule) {
            return (ProcessMaker)this.unimplementedNull();
        }
    }

    @Override
    public FileStat allocateStat() {
        try {
            return this.posix.allocateStat();
        }
        catch (UnsatisfiedLinkError ule) {
            return (FileStat)this.unimplementedNull();
        }
    }

    @Override
    public MsgHdr allocateMsgHdr() {
        try {
            return this.posix.allocateMsgHdr();
        }
        catch (UnsatisfiedLinkError ule) {
            return (MsgHdr)this.unimplementedNull();
        }
    }

    @Override
    public int chdir(String path2) {
        try {
            return this.posix.chdir(path2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int chmod(String filename2, int mode2) {
        try {
            return this.posix.chmod(filename2, mode2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int fchmod(int fd, int mode2) {
        try {
            return this.posix.fchmod(fd, mode2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int chown(String filename2, int user, int group2) {
        try {
            return this.posix.chown(filename2, user, group2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int fchown(int fd, int user, int group2) {
        try {
            return this.posix.fchown(fd, user, group2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int endgrent() {
        try {
            return this.posix.endgrent();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int endpwent() {
        try {
            return this.posix.endpwent();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int errno() {
        return this.posix.errno();
    }

    @Override
    public void errno(int value2) {
        this.posix.errno(value2);
    }

    @Override
    public int exec(String path2, String ... args2) {
        try {
            return this.posix.exec(path2, args2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int exec(String path2, String[] args2, String[] envp) {
        try {
            return this.posix.exec(path2, args2, envp);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int execv(String path2, String[] argv) {
        try {
            return this.posix.execv(path2, argv);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int execve(String path2, String[] argv, String[] envp) {
        try {
            return this.posix.execve(path2, argv, envp);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int fork() {
        try {
            return this.posix.fork();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public FileStat fstat(int fd) {
        try {
            return this.posix.fstat(fd);
        }
        catch (UnsatisfiedLinkError ule) {
            return (FileStat)this.unimplementedNull();
        }
    }

    @Override
    public int fstat(int fd, FileStat stat2) {
        try {
            return this.posix.fstat(fd, stat2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public FileStat fstat(FileDescriptor descriptor) {
        try {
            return this.posix.fstat(descriptor);
        }
        catch (UnsatisfiedLinkError ule) {
            return (FileStat)this.unimplementedNull();
        }
    }

    @Override
    public int fstat(FileDescriptor descriptor, FileStat stat2) {
        try {
            return this.posix.fstat(descriptor, stat2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int getegid() {
        try {
            return this.posix.getegid();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int geteuid() {
        try {
            return this.posix.geteuid();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int getgid() {
        try {
            return this.posix.getgid();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int getdtablesize() {
        try {
            return this.posix.getdtablesize();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public Group getgrent() {
        try {
            return this.posix.getgrent();
        }
        catch (UnsatisfiedLinkError ule) {
            return (Group)this.unimplementedNull();
        }
    }

    @Override
    public Group getgrgid(int which) {
        try {
            return this.posix.getgrgid(which);
        }
        catch (UnsatisfiedLinkError ule) {
            return (Group)this.unimplementedNull();
        }
    }

    @Override
    public Group getgrnam(String which) {
        try {
            return this.posix.getgrnam(which);
        }
        catch (UnsatisfiedLinkError ule) {
            return (Group)this.unimplementedNull();
        }
    }

    @Override
    public String getlogin() {
        try {
            return this.posix.getlogin();
        }
        catch (UnsatisfiedLinkError ule) {
            return (String)this.unimplementedNull();
        }
    }

    @Override
    public int getpgid() {
        try {
            return this.posix.getpgid();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int getpgid(int pid2) {
        try {
            return this.posix.getpgid(pid2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int getpgrp() {
        try {
            return this.posix.getpgrp();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int getpid() {
        try {
            return this.posix.getpid();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int getppid() {
        try {
            return this.posix.getppid();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int getpriority(int which, int who) {
        try {
            return this.posix.getpriority(which, who);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public Passwd getpwent() {
        try {
            return this.posix.getpwent();
        }
        catch (UnsatisfiedLinkError ule) {
            return (Passwd)this.unimplementedNull();
        }
    }

    @Override
    public Passwd getpwnam(String which) {
        try {
            return this.posix.getpwnam(which);
        }
        catch (UnsatisfiedLinkError ule) {
            return (Passwd)this.unimplementedNull();
        }
    }

    @Override
    public Passwd getpwuid(int which) {
        try {
            return this.posix.getpwuid(which);
        }
        catch (UnsatisfiedLinkError ule) {
            return (Passwd)this.unimplementedNull();
        }
    }

    @Override
    public int getuid() {
        try {
            return this.posix.getuid();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public boolean isatty(FileDescriptor descriptor) {
        try {
            return this.posix.isatty(descriptor);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedBool();
        }
    }

    @Override
    public int kill(int pid2, int signal2) {
        try {
            return this.posix.kill(pid2, signal2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public SignalHandler signal(Signal sig, SignalHandler handler) {
        try {
            return this.posix.signal(sig, handler);
        }
        catch (UnsatisfiedLinkError ule) {
            return (SignalHandler)this.unimplementedNull();
        }
    }

    @Override
    public int lchmod(String filename2, int mode2) {
        try {
            return this.posix.lchmod(filename2, mode2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int lchown(String filename2, int user, int group2) {
        try {
            return this.posix.lchown(filename2, user, group2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int link(String oldpath, String newpath) {
        try {
            return this.posix.link(oldpath, newpath);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public FileStat lstat(String path2) {
        try {
            return this.posix.lstat(path2);
        }
        catch (UnsatisfiedLinkError ule) {
            return (FileStat)this.unimplementedNull();
        }
    }

    @Override
    public int lstat(String path2, FileStat stat2) {
        try {
            return this.posix.lstat(path2, stat2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int mkdir(String path2, int mode2) {
        try {
            return this.posix.mkdir(path2, mode2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public String readlink(String path2) throws IOException {
        try {
            return this.posix.readlink(path2);
        }
        catch (UnsatisfiedLinkError ule) {
            return (String)this.unimplementedNull();
        }
    }

    @Override
    public int rmdir(String path2) {
        try {
            return this.posix.rmdir(path2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int setegid(int egid2) {
        try {
            return this.posix.setegid(egid2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int seteuid(int euid2) {
        try {
            return this.posix.seteuid(euid2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int setgid(int gid2) {
        try {
            return this.posix.setgid(gid2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int setgrent() {
        try {
            return this.posix.setgrent();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int setpgid(int pid2, int pgid) {
        try {
            return this.posix.setpgid(pid2, pgid);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int setpgrp(int pid2, int pgrp) {
        try {
            return this.posix.setpgrp(pid2, pgrp);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int setpriority(int which, int who, int prio) {
        try {
            return this.posix.setpriority(which, who, prio);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int setpwent() {
        try {
            return this.posix.setpwent();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int setsid() {
        try {
            return this.posix.setsid();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int setuid(int uid2) {
        try {
            return this.posix.setuid(uid2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public FileStat stat(String path2) {
        try {
            return this.posix.stat(path2);
        }
        catch (UnsatisfiedLinkError ule) {
            return (FileStat)this.unimplementedNull();
        }
    }

    @Override
    public int stat(String path2, FileStat stat2) {
        try {
            return this.posix.stat(path2, stat2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int symlink(String oldpath, String newpath) {
        try {
            return this.posix.symlink(oldpath, newpath);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int umask(int mask) {
        try {
            return this.posix.umask(mask);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int utimes(String path2, long[] atimeval, long[] mtimeval) {
        try {
            return this.posix.utimes(path2, atimeval, mtimeval);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int futimes(int fd, long[] atimeval, long[] mtimeval) {
        try {
            return this.posix.futimes(fd, atimeval, mtimeval);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int wait(int[] status2) {
        try {
            return this.posix.wait(status2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int waitpid(int pid2, int[] status2, int flags) {
        return this.waitpid((long)pid2, status2, flags);
    }

    @Override
    public int waitpid(long pid2, int[] status2, int flags) {
        try {
            return this.posix.waitpid(pid2, status2, flags);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public boolean isNative() {
        return this.posix.isNative();
    }

    @Override
    public LibC libc() {
        return this.posix.libc();
    }

    @Override
    public String getenv(String envName) {
        try {
            return this.posix.getenv(envName);
        }
        catch (UnsatisfiedLinkError ule) {
            return (String)this.unimplementedNull();
        }
    }

    @Override
    public int setenv(String envName, String envValue, int overwrite) {
        try {
            return this.posix.setenv(envName, envValue, overwrite);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int unsetenv(String envName) {
        try {
            return this.posix.unsetenv(envName);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public long posix_spawnp(String path2, Collection<? extends SpawnFileAction> fileActions, Collection<? extends CharSequence> argv, Collection<? extends CharSequence> envp) {
        try {
            return this.posix.posix_spawnp(path2, fileActions, argv, envp);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public long posix_spawnp(String path2, Collection<? extends SpawnFileAction> fileActions, Collection<? extends SpawnAttribute> spawnAttributes, Collection<? extends CharSequence> argv, Collection<? extends CharSequence> envp) {
        try {
            return this.posix.posix_spawnp(path2, fileActions, spawnAttributes, argv, envp);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public long sysconf(Sysconf name2) {
        try {
            return this.posix.sysconf(name2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public Times times() {
        try {
            return this.posix.times();
        }
        catch (UnsatisfiedLinkError ule) {
            return (Times)this.unimplementedNull();
        }
    }

    @Override
    public int flock(int fd, int mode2) {
        return this.posix.flock(fd, mode2);
    }

    @Override
    public int dup(int fd) {
        try {
            return this.posix.dup(fd);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int dup2(int oldFd, int newFd) {
        try {
            return this.posix.dup2(oldFd, newFd);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int fcntlInt(int fd, Fcntl fcntlConst, int arg2) {
        try {
            return this.posix.fcntlInt(fd, fcntlConst, arg2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int fcntl(int fd, Fcntl fcntlConst) {
        try {
            return this.posix.fcntl(fd, fcntlConst);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int fcntl(int fd, Fcntl fcntlConst, int ... arg2) {
        try {
            return this.posix.fcntl(fd, fcntlConst);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int close(int fd) {
        try {
            return this.posix.close(fd);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int unlink(CharSequence path2) {
        try {
            return this.posix.unlink(path2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int open(CharSequence path2, int flags, int perm) {
        try {
            return this.posix.open(path2, flags, perm);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int read(int fd, byte[] buf, int n) {
        try {
            return this.posix.read(fd, buf, n);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int write(int fd, byte[] buf, int n) {
        try {
            return this.posix.write(fd, buf, n);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int read(int fd, ByteBuffer buf, int n) {
        try {
            return this.posix.read(fd, buf, n);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int write(int fd, ByteBuffer buf, int n) {
        try {
            return this.posix.write(fd, buf, n);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int pread(int fd, byte[] buf, int n, int offset2) {
        try {
            return this.posix.pread(fd, buf, n, offset2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int pwrite(int fd, byte[] buf, int n, int offset2) {
        try {
            return this.posix.pwrite(fd, buf, n, offset2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int pread(int fd, ByteBuffer buf, int n, int offset2) {
        try {
            return this.posix.pread(fd, buf, n, offset2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int pwrite(int fd, ByteBuffer buf, int n, int offset2) {
        try {
            return this.posix.pwrite(fd, buf, n, offset2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int lseek(int fd, long offset2, int whence) {
        try {
            return this.posix.lseek(fd, offset2, whence);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int pipe(int[] fds) {
        try {
            return this.posix.pipe(fds);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int socketpair(int domain, int type2, int protocol2, int[] fds) {
        try {
            return this.posix.socketpair(domain, type2, protocol2, fds);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int sendmsg(int socket2, MsgHdr message2, int flags) {
        try {
            return this.posix.sendmsg(socket2, message2, flags);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int recvmsg(int socket2, MsgHdr message2, int flags) {
        try {
            return this.posix.recvmsg(socket2, message2, flags);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int ftruncate(int fd, long offset2) {
        try {
            return this.posix.ftruncate(fd, offset2);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public String getcwd() {
        try {
            return this.posix.getcwd();
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedString();
        }
    }

    @Override
    public int fsync(int fd) {
        try {
            return this.posix.fsync(fd);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int fdatasync(int fd) {
        try {
            return this.posix.fsync(fd);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }
}

