/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.util;

import ch.ethz.ssh2.log.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedList;

public class TimeoutService {
    private static final Logger log = Logger.getLogger(class$ch$ethz$ssh2$util$TimeoutService == null ? (class$ch$ethz$ssh2$util$TimeoutService = TimeoutService.class$("ch.ethz.ssh2.util.TimeoutService")) : class$ch$ethz$ssh2$util$TimeoutService);
    private static final LinkedList todolist = new LinkedList();
    private static Thread timeoutThread = null;
    static /* synthetic */ Class class$ch$ethz$ssh2$util$TimeoutService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final TimeoutToken addTimeoutHandler(long runTime, Runnable handler) {
        TimeoutToken token = new TimeoutToken(runTime, handler);
        LinkedList linkedList = todolist;
        synchronized (linkedList) {
            todolist.add(token);
            Collections.sort(todolist);
            if (timeoutThread != null) {
                timeoutThread.interrupt();
            } else {
                timeoutThread = new TimeoutThread();
                timeoutThread.setDaemon(true);
                timeoutThread.start();
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void cancelTimeoutHandler(TimeoutToken token) {
        LinkedList linkedList = todolist;
        synchronized (linkedList) {
            todolist.remove(token);
            if (timeoutThread != null) {
                timeoutThread.interrupt();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TimeoutThread
    extends Thread {
        private TimeoutThread() {
        }

        public void run() {
            LinkedList linkedList = todolist;
            synchronized (linkedList) {
                block7: while (true) {
                    while (true) {
                        if (todolist.size() == 0) {
                            timeoutThread = null;
                            return;
                        }
                        long now = System.currentTimeMillis();
                        TimeoutToken tt = (TimeoutToken)todolist.getFirst();
                        if (tt.runTime > now) {
                            try {
                                todolist.wait(tt.runTime - now);
                            }
                            catch (InterruptedException e) {}
                            continue;
                        }
                        todolist.removeFirst();
                        try {
                            tt.handler.run();
                            continue block7;
                        }
                        catch (Exception e) {
                            StringWriter sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            log.log(20, "Exeception in Timeout handler:" + e.getMessage() + "(" + sw.toString() + ")");
                            continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    public static class TimeoutToken
    implements Comparable {
        private long runTime;
        private Runnable handler;

        private TimeoutToken(long runTime, Runnable handler) {
            this.runTime = runTime;
            this.handler = handler;
        }

        public int compareTo(Object o) {
            TimeoutToken t = (TimeoutToken)o;
            if (this.runTime > t.runTime) {
                return 1;
            }
            if (this.runTime == t.runTime) {
                return 0;
            }
            return -1;
        }
    }
}

