/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Primary;

@Conditional(value={MultipleNonPrimaryMeterRegistriesCondition.class})
class CompositeMeterRegistryConfiguration {
    CompositeMeterRegistryConfiguration() {
    }

    @Bean
    @Primary
    public CompositeMeterRegistry compositeMeterRegistry(Clock clock, List<MeterRegistry> registries) {
        return new CompositeMeterRegistry(clock, registries);
    }

    static class MultipleNonPrimaryMeterRegistriesCondition
    extends NoneNestedConditions {
        MultipleNonPrimaryMeterRegistriesCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnSingleCandidate(value=MeterRegistry.class)
        static class SingleInjectableMeterRegistry {
            SingleInjectableMeterRegistry() {
            }
        }

        @ConditionalOnMissingBean(value={MeterRegistry.class})
        static class NoMeterRegistryCondition {
            NoMeterRegistryCondition() {
            }
        }
    }
}

