/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import org.springframework.boot.buildpack.platform.json.MappedObject;
import org.springframework.boot.buildpack.platform.json.SharedObjectMapper;
import org.springframework.boot.buildpack.platform.system.Environment;

final class DockerConfigurationMetadata {
    private static final String DOCKER_CONFIG = "DOCKER_CONFIG";
    private static final String DEFAULT_CONTEXT = "default";
    private static final String CONFIG_DIR = ".docker";
    private static final String CONTEXTS_DIR = "contexts";
    private static final String META_DIR = "meta";
    private static final String TLS_DIR = "tls";
    private static final String DOCKER_ENDPOINT = "docker";
    private static final String CONFIG_FILE_NAME = "config.json";
    private static final String CONTEXT_FILE_NAME = "meta.json";
    private final String configLocation;
    private final DockerConfig config;
    private final DockerContext context;

    private DockerConfigurationMetadata(String configLocation, DockerConfig config, DockerContext context) {
        this.configLocation = configLocation;
        this.config = config;
        this.context = context;
    }

    DockerConfig getConfiguration() {
        return this.config;
    }

    DockerContext getContext() {
        return this.context;
    }

    DockerContext forContext(String context) {
        return DockerConfigurationMetadata.createDockerContext(this.configLocation, context);
    }

    static DockerConfigurationMetadata from(Environment environment) {
        String configLocation = environment.get(DOCKER_CONFIG) != null ? environment.get(DOCKER_CONFIG) : Path.of(System.getProperty("user.home"), CONFIG_DIR).toString();
        DockerConfig dockerConfig = DockerConfigurationMetadata.createDockerConfig(configLocation);
        DockerContext dockerContext = DockerConfigurationMetadata.createDockerContext(configLocation, dockerConfig.getCurrentContext());
        return new DockerConfigurationMetadata(configLocation, dockerConfig, dockerContext);
    }

    private static DockerConfig createDockerConfig(String configLocation) {
        Path path = Path.of(configLocation, CONFIG_FILE_NAME);
        if (!path.toFile().exists()) {
            return DockerConfig.empty();
        }
        try {
            return DockerConfig.fromJson(DockerConfigurationMetadata.readPathContent(path));
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException("Error parsing Docker configuration file '" + String.valueOf(path) + "'", ex);
        }
    }

    private static DockerContext createDockerContext(String configLocation, String currentContext) {
        if (currentContext == null || DEFAULT_CONTEXT.equals(currentContext)) {
            return DockerContext.empty();
        }
        Path metaPath = Path.of(configLocation, CONTEXTS_DIR, META_DIR, DockerConfigurationMetadata.asHash(currentContext), CONTEXT_FILE_NAME);
        Path tlsPath = Path.of(configLocation, CONTEXTS_DIR, TLS_DIR, DockerConfigurationMetadata.asHash(currentContext), DOCKER_ENDPOINT);
        if (!metaPath.toFile().exists()) {
            throw new IllegalArgumentException("Docker context '" + currentContext + "' does not exist");
        }
        try {
            DockerContext context = DockerContext.fromJson(DockerConfigurationMetadata.readPathContent(metaPath));
            if (tlsPath.toFile().isDirectory()) {
                return context.withTlsPath(tlsPath.toString());
            }
            return context;
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException("Error parsing Docker context metadata file '" + String.valueOf(metaPath) + "'", ex);
        }
    }

    private static String asHash(String currentContext) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(currentContext.getBytes(StandardCharsets.UTF_8));
            return HexFormat.of().formatHex(hash);
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    private static String readPathContent(Path path) {
        try {
            return Files.readString(path);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error reading Docker configuration file '" + String.valueOf(path) + "'", ex);
        }
    }

    static final class DockerConfig
    extends MappedObject {
        private final String currentContext = this.valueAt("/currentContext", String.class);

        private DockerConfig(JsonNode node) {
            super(node, MethodHandles.lookup());
        }

        String getCurrentContext() {
            return this.currentContext;
        }

        static DockerConfig fromJson(String json) throws JsonProcessingException {
            return new DockerConfig(SharedObjectMapper.get().readTree(json));
        }

        static DockerConfig empty() {
            return new DockerConfig((JsonNode)NullNode.instance);
        }
    }

    static final class DockerContext
    extends MappedObject {
        private final String dockerHost = this.valueAt("/Endpoints/docker/Host", String.class);
        private final Boolean skipTlsVerify = this.valueAt("/Endpoints/docker/SkipTLSVerify", Boolean.class);
        private final String tlsPath;

        private DockerContext(JsonNode node, String tlsPath) {
            super(node, MethodHandles.lookup());
            this.tlsPath = tlsPath;
        }

        String getDockerHost() {
            return this.dockerHost;
        }

        Boolean isTlsVerify() {
            return this.skipTlsVerify != null && this.skipTlsVerify == false;
        }

        String getTlsPath() {
            return this.tlsPath;
        }

        DockerContext withTlsPath(String tlsPath) {
            return new DockerContext(this.getNode(), tlsPath);
        }

        static DockerContext fromJson(String json) throws JsonProcessingException {
            return new DockerContext(SharedObjectMapper.get().readTree(json), null);
        }

        static DockerContext empty() {
            return new DockerContext((JsonNode)NullNode.instance, null);
        }
    }
}

