/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.ParentContextApplicationContextInitializer;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.logging.LoggingApplicationListener;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.cloud.bootstrap.BootstrapImportSelectorConfiguration;
import org.springframework.cloud.bootstrap.LoggingSystemShutdownListener;
import org.springframework.cloud.bootstrap.encrypt.EnvironmentDecryptApplicationInitializer;
import org.springframework.cloud.bootstrap.support.OriginTrackedCompositePropertySource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class BootstrapApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    public static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrap";
    public static final int DEFAULT_ORDER = -2147483643;
    public static final String DEFAULT_PROPERTIES = "springCloudDefaultProperties";
    private int order = -2147483643;

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        if (!((Boolean)environment.getProperty("spring.cloud.bootstrap.enabled", Boolean.class, (Object)true)).booleanValue()) {
            return;
        }
        if (environment.getPropertySources().contains(BOOTSTRAP_PROPERTY_SOURCE_NAME)) {
            return;
        }
        ConfigurableApplicationContext context = null;
        String configName = environment.resolvePlaceholders("${spring.cloud.bootstrap.name:bootstrap}");
        for (ApplicationContextInitializer initializer : event.getSpringApplication().getInitializers()) {
            if (!(initializer instanceof ParentContextApplicationContextInitializer)) continue;
            context = this.findBootstrapContext((ParentContextApplicationContextInitializer)initializer, configName);
        }
        if (context == null) {
            context = this.bootstrapServiceContext(environment, event.getSpringApplication(), configName);
            event.getSpringApplication().addListeners(new ApplicationListener[]{new CloseContextOnFailureApplicationListener(context)});
        }
        this.apply(context, event.getSpringApplication(), environment);
    }

    private ConfigurableApplicationContext findBootstrapContext(ParentContextApplicationContextInitializer initializer, String configName) {
        Field field = ReflectionUtils.findField(ParentContextApplicationContextInitializer.class, (String)"parent");
        ReflectionUtils.makeAccessible((Field)field);
        ConfigurableApplicationContext parent = this.safeCast(ConfigurableApplicationContext.class, ReflectionUtils.getField((Field)field, (Object)initializer));
        if (parent != null && !configName.equals(parent.getId())) {
            parent = this.safeCast(ConfigurableApplicationContext.class, parent.getParent());
        }
        return parent;
    }

    private <T> T safeCast(Class<T> type, Object object) {
        try {
            return type.cast(object);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private ConfigurableApplicationContext bootstrapServiceContext(ConfigurableEnvironment environment, SpringApplication application, String configName) {
        StandardEnvironment bootstrapEnvironment = new StandardEnvironment();
        MutablePropertySources bootstrapProperties = bootstrapEnvironment.getPropertySources();
        for (PropertySource source : bootstrapProperties) {
            bootstrapProperties.remove(source.getName());
        }
        String configLocation = environment.resolvePlaceholders("${spring.cloud.bootstrap.location:}");
        HashMap<String, String> bootstrapMap = new HashMap<String, String>();
        bootstrapMap.put("spring.config.name", configName);
        bootstrapMap.put("spring.main.web-application-type", "none");
        if (StringUtils.hasText((String)configLocation)) {
            bootstrapMap.put("spring.config.location", configLocation);
        }
        bootstrapProperties.addFirst((PropertySource)new MapPropertySource(BOOTSTRAP_PROPERTY_SOURCE_NAME, bootstrapMap));
        for (PropertySource source : environment.getPropertySources()) {
            if (source instanceof PropertySource.StubPropertySource) continue;
            bootstrapProperties.addLast(source);
        }
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[0]).profiles(environment.getActiveProfiles()).bannerMode(Banner.Mode.OFF).environment((ConfigurableEnvironment)bootstrapEnvironment).registerShutdownHook(false).logStartupInfo(false).web(WebApplicationType.NONE);
        SpringApplication builderApplication = builder.application();
        if (builderApplication.getMainApplicationClass() == null) {
            builder.main(application.getMainApplicationClass());
        }
        if (environment.getPropertySources().contains("refreshArgs")) {
            builderApplication.setListeners(this.filterListeners(builderApplication.getListeners()));
        }
        builder.sources(new Class[]{BootstrapImportSelectorConfiguration.class});
        ConfigurableApplicationContext context = builder.run(new String[0]);
        context.setId(BOOTSTRAP_PROPERTY_SOURCE_NAME);
        this.addAncestorInitializer(application, context);
        bootstrapProperties.remove(BOOTSTRAP_PROPERTY_SOURCE_NAME);
        this.mergeDefaultProperties(environment.getPropertySources(), bootstrapProperties);
        return context;
    }

    private Collection<? extends ApplicationListener<?>> filterListeners(Set<ApplicationListener<?>> listeners) {
        LinkedHashSet result = new LinkedHashSet();
        for (ApplicationListener<?> listener : listeners) {
            if (listener instanceof LoggingApplicationListener || listener instanceof LoggingSystemShutdownListener) continue;
            result.add(listener);
        }
        return result;
    }

    private void mergeDefaultProperties(MutablePropertySources environment, MutablePropertySources bootstrap) {
        String name = DEFAULT_PROPERTIES;
        if (bootstrap.contains(name)) {
            PropertySource source = bootstrap.get(name);
            if (!environment.contains(name)) {
                environment.addLast(source);
            } else {
                PropertySource target = environment.get(name);
                if (target instanceof MapPropertySource && target != source && source instanceof MapPropertySource) {
                    Map targetMap = (Map)((MapPropertySource)target).getSource();
                    Map map = (Map)((MapPropertySource)source).getSource();
                    for (String key : map.keySet()) {
                        if (target.containsProperty(key)) continue;
                        targetMap.put(key, map.get(key));
                    }
                }
            }
        }
        this.mergeAdditionalPropertySources(environment, bootstrap);
    }

    private void mergeAdditionalPropertySources(MutablePropertySources environment, MutablePropertySources bootstrap) {
        PropertySource defaultProperties = environment.get(DEFAULT_PROPERTIES);
        ExtendedDefaultPropertySource result = defaultProperties instanceof ExtendedDefaultPropertySource ? (ExtendedDefaultPropertySource)defaultProperties : new ExtendedDefaultPropertySource(DEFAULT_PROPERTIES, defaultProperties);
        for (PropertySource source : bootstrap) {
            if (environment.contains(source.getName())) continue;
            result.add(source);
        }
        for (String name : result.getPropertySourceNames()) {
            bootstrap.remove(name);
        }
        this.addOrReplace(environment, (PropertySource<?>)result);
        this.addOrReplace(bootstrap, (PropertySource<?>)result);
    }

    private void addOrReplace(MutablePropertySources environment, PropertySource<?> result) {
        if (environment.contains(result.getName())) {
            environment.replace(result.getName(), result);
        } else {
            environment.addLast(result);
        }
    }

    private void addAncestorInitializer(SpringApplication application, ConfigurableApplicationContext context) {
        boolean installed = false;
        for (ApplicationContextInitializer initializer : application.getInitializers()) {
            if (!(initializer instanceof AncestorInitializer)) continue;
            installed = true;
            ((AncestorInitializer)initializer).setParent(context);
        }
        if (!installed) {
            application.addInitializers(new ApplicationContextInitializer[]{new AncestorInitializer(context)});
        }
    }

    private void apply(ConfigurableApplicationContext context, SpringApplication application, ConfigurableEnvironment environment) {
        if (application.getAllSources().contains(BootstrapMarkerConfiguration.class)) {
            return;
        }
        application.addPrimarySources(Arrays.asList(BootstrapMarkerConfiguration.class));
        LinkedHashSet<ApplicationContextInitializer> target = new LinkedHashSet<ApplicationContextInitializer>(application.getInitializers());
        target.addAll(this.getOrderedBeansOfType((ListableBeanFactory)context, ApplicationContextInitializer.class));
        application.setInitializers(target);
        this.addBootstrapDecryptInitializer(application);
    }

    private void addBootstrapDecryptInitializer(SpringApplication application) {
        DelegatingEnvironmentDecryptApplicationInitializer decrypter = null;
        LinkedHashSet<ApplicationContextInitializer> initializers = new LinkedHashSet<ApplicationContextInitializer>();
        for (ApplicationContextInitializer ini : application.getInitializers()) {
            if (ini instanceof EnvironmentDecryptApplicationInitializer) {
                ApplicationContextInitializer del = ini;
                decrypter = new DelegatingEnvironmentDecryptApplicationInitializer((ApplicationContextInitializer<ConfigurableApplicationContext>)del);
                initializers.add(ini);
                initializers.add(decrypter);
                continue;
            }
            if (ini instanceof DelegatingEnvironmentDecryptApplicationInitializer) continue;
            initializers.add(ini);
        }
        ArrayList target = new ArrayList(initializers);
        application.setInitializers(target);
    }

    private <T> List<T> getOrderedBeansOfType(ListableBeanFactory context, Class<T> type) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String name : context.getBeanNamesForType(type)) {
            result.add(context.getBean(name, type));
        }
        AnnotationAwareOrderComparator.sort(result);
        return result;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private static class CloseContextOnFailureApplicationListener
    implements SmartApplicationListener {
        private final ConfigurableApplicationContext context;

        CloseContextOnFailureApplicationListener(ConfigurableApplicationContext context) {
            this.context = context;
        }

        public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
            return ApplicationFailedEvent.class.isAssignableFrom(eventType);
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof ApplicationFailedEvent) {
                this.context.close();
            }
        }
    }

    private static class ExtendedDefaultPropertySource
    extends SystemEnvironmentPropertySource
    implements OriginLookup<String> {
        private final OriginTrackedCompositePropertySource sources;
        private final List<String> names = new ArrayList<String>();

        ExtendedDefaultPropertySource(String name, PropertySource<?> propertySource) {
            super(name, ExtendedDefaultPropertySource.findMap(propertySource));
            this.sources = new OriginTrackedCompositePropertySource(name);
        }

        private static Map<String, Object> findMap(PropertySource<?> propertySource) {
            if (propertySource instanceof MapPropertySource) {
                return (Map)propertySource.getSource();
            }
            return new LinkedHashMap<String, Object>();
        }

        public CompositePropertySource getPropertySources() {
            return this.sources;
        }

        public List<String> getPropertySourceNames() {
            return this.names;
        }

        public void add(PropertySource<?> source) {
            if (source instanceof OriginTrackedMapPropertySource && !this.names.contains(source.getName())) {
                this.sources.addPropertySource(source);
                this.names.add(source.getName());
            }
        }

        public Object getProperty(String name) {
            if (this.sources.containsProperty(name)) {
                return this.sources.getProperty(name);
            }
            return super.getProperty(name);
        }

        public boolean containsProperty(String name) {
            if (this.sources.containsProperty(name)) {
                return true;
            }
            return super.containsProperty(name);
        }

        public String[] getPropertyNames() {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(Arrays.asList(this.sources.getPropertyNames()));
            names.addAll(Arrays.asList(super.getPropertyNames()));
            return names.toArray(new String[0]);
        }

        public Origin getOrigin(String name) {
            return this.sources.getOrigin(name);
        }
    }

    @Order(value=-2147483639)
    private static class DelegatingEnvironmentDecryptApplicationInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private ApplicationContextInitializer<ConfigurableApplicationContext> delegate;

        DelegatingEnvironmentDecryptApplicationInitializer(ApplicationContextInitializer<ConfigurableApplicationContext> delegate) {
            this.delegate = delegate;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            this.delegate.initialize(applicationContext);
        }
    }

    private static class AncestorInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext>,
    Ordered {
        private ConfigurableApplicationContext parent;

        AncestorInitializer(ConfigurableApplicationContext parent) {
            this.parent = parent;
        }

        public void setParent(ConfigurableApplicationContext parent) {
            this.parent = parent;
        }

        public int getOrder() {
            return -2147483643;
        }

        public void initialize(ConfigurableApplicationContext context) {
            while (context.getParent() != null && context.getParent() != context) {
                context = (ConfigurableApplicationContext)context.getParent();
            }
            this.reorderSources(context.getEnvironment());
            new ParentContextApplicationContextInitializer((ApplicationContext)this.parent).initialize(context);
        }

        private void reorderSources(ConfigurableEnvironment environment) {
            PropertySource removed = environment.getPropertySources().remove(BootstrapApplicationListener.DEFAULT_PROPERTIES);
            if (removed instanceof ExtendedDefaultPropertySource) {
                ExtendedDefaultPropertySource defaultProperties = (ExtendedDefaultPropertySource)removed;
                environment.getPropertySources().addLast((PropertySource)new MapPropertySource(BootstrapApplicationListener.DEFAULT_PROPERTIES, (Map)defaultProperties.getSource()));
                for (PropertySource source : defaultProperties.getPropertySources().getPropertySources()) {
                    if (environment.getPropertySources().contains(source.getName())) continue;
                    environment.getPropertySources().addBefore(BootstrapApplicationListener.DEFAULT_PROPERTIES, source);
                }
            }
        }
    }

    private static class BootstrapMarkerConfiguration {
        private BootstrapMarkerConfiguration() {
        }
    }
}

