/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.rewrite;

import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.RewriteFunction;
import org.springframework.cloud.gateway.support.BodyInserterContext;
import org.springframework.cloud.gateway.support.CachedBodyOutputMessage;
import org.springframework.cloud.gateway.support.DefaultServerRequest;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ModifyRequestBodyGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    private final List<HttpMessageReader<?>> messageReaders = HandlerStrategies.withDefaults().messageReaders();

    public ModifyRequestBodyGatewayFilterFactory() {
        super(Config.class);
    }

    @Deprecated
    public ModifyRequestBodyGatewayFilterFactory(ServerCodecConfigurer codecConfigurer) {
        this();
    }

    @Override
    public GatewayFilter apply(Config config) {
        return (exchange, chain) -> {
            Class inClass = config.getInClass();
            DefaultServerRequest serverRequest = new DefaultServerRequest(exchange, this.messageReaders);
            Mono modifiedBody = serverRequest.bodyToMono(inClass).flatMap(o -> config.rewriteFunction.apply(exchange, o));
            BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)modifiedBody, (Class)config.getOutClass());
            final HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map)exchange.getRequest().getHeaders());
            headers.remove((Object)"Content-Length");
            if (config.getContentType() != null) {
                headers.set("Content-Type", config.getContentType());
            }
            final CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage(exchange, headers);
            return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
                ServerHttpRequestDecorator decorator = new ServerHttpRequestDecorator(exchange.getRequest()){

                    public HttpHeaders getHeaders() {
                        long contentLength = headers.getContentLength();
                        HttpHeaders httpHeaders = new HttpHeaders();
                        httpHeaders.putAll((Map)super.getHeaders());
                        if (contentLength > 0L) {
                            httpHeaders.setContentLength(contentLength);
                        } else {
                            httpHeaders.set("Transfer-Encoding", "chunked");
                        }
                        return httpHeaders;
                    }

                    public Flux<DataBuffer> getBody() {
                        return outputMessage.getBody();
                    }
                };
                return chain.filter(exchange.mutate().request((ServerHttpRequest)decorator).build());
            }));
        };
    }

    public static class Config {
        private Class inClass;
        private Class outClass;
        private String contentType;
        @Deprecated
        private Map<String, Object> inHints;
        @Deprecated
        private Map<String, Object> outHints;
        private RewriteFunction rewriteFunction;

        public Class getInClass() {
            return this.inClass;
        }

        public Config setInClass(Class inClass) {
            this.inClass = inClass;
            return this;
        }

        public Class getOutClass() {
            return this.outClass;
        }

        public Config setOutClass(Class outClass) {
            this.outClass = outClass;
            return this;
        }

        @Deprecated
        public Map<String, Object> getInHints() {
            return this.inHints;
        }

        @Deprecated
        public Config setInHints(Map<String, Object> inHints) {
            this.inHints = inHints;
            return this;
        }

        @Deprecated
        public Map<String, Object> getOutHints() {
            return this.outHints;
        }

        @Deprecated
        public Config setOutHints(Map<String, Object> outHints) {
            this.outHints = outHints;
            return this;
        }

        public RewriteFunction getRewriteFunction() {
            return this.rewriteFunction;
        }

        public Config setRewriteFunction(RewriteFunction rewriteFunction) {
            this.rewriteFunction = rewriteFunction;
            return this;
        }

        public <T, R> Config setRewriteFunction(Class<T> inClass, Class<R> outClass, RewriteFunction<T, R> rewriteFunction) {
            this.setInClass(inClass);
            this.setOutClass(outClass);
            this.setRewriteFunction(rewriteFunction);
            return this;
        }

        public String getContentType() {
            return this.contentType;
        }

        public Config setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }
    }
}

