/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.gateway.config.GatewayLoadBalancerClientAutoConfiguration;
import org.springframework.cloud.gateway.config.LoadBalancerProperties;
import org.springframework.cloud.gateway.filter.ReactiveLoadBalancerClientFilter;
import org.springframework.cloud.loadbalancer.config.LoadBalancerAutoConfiguration;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.web.reactive.DispatcherHandler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ReactiveLoadBalancer.class, LoadBalancerAutoConfiguration.class, DispatcherHandler.class})
@AutoConfigureBefore(value={GatewayLoadBalancerClientAutoConfiguration.class})
@AutoConfigureAfter(value={LoadBalancerAutoConfiguration.class})
@EnableConfigurationProperties(value={LoadBalancerProperties.class})
public class GatewayReactiveLoadBalancerClientAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={LoadBalancerClientFactory.class})
    @ConditionalOnMissingBean(value={ReactiveLoadBalancerClientFilter.class})
    @Conditional(value={OnNoRibbonDefaultCondition.class})
    public ReactiveLoadBalancerClientFilter gatewayLoadBalancerClientFilter(LoadBalancerClientFactory clientFactory, LoadBalancerProperties properties) {
        return new ReactiveLoadBalancerClientFilter(clientFactory, properties);
    }

    private static final class OnNoRibbonDefaultCondition
    extends AnyNestedCondition {
        private OnNoRibbonDefaultCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnMissingClass(value={"org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient"})
        static class RibbonLoadBalancerNotPresent {
            RibbonLoadBalancerNotPresent() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.ribbon.enabled"}, havingValue="false")
        static class RibbonNotEnabled {
            RibbonNotEnabled() {
            }
        }
    }
}

