/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.post;

import com.netflix.util.Pair;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.util.HTTPRequestUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.List;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.util.ReflectionUtils;

public class SendResponseFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(SendResponseFilter.class);
    private boolean useServlet31 = true;
    private ZuulProperties zuulProperties;
    private ThreadLocal<byte[]> buffers;

    @Deprecated
    public SendResponseFilter() {
        this(new ZuulProperties());
    }

    public SendResponseFilter(ZuulProperties zuulProperties) {
        this.zuulProperties = zuulProperties;
        try {
            HttpServletResponse.class.getMethod("setContentLengthLong", Long.TYPE);
        }
        catch (NoSuchMethodException e) {
            this.useServlet31 = false;
        }
        this.buffers = ThreadLocal.withInitial(() -> new byte[zuulProperties.getInitialStreamBufferSize()]);
    }

    boolean isUseServlet31() {
        return this.useServlet31;
    }

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 1000;
    }

    public boolean shouldFilter() {
        RequestContext context = RequestContext.getCurrentContext();
        return context.getThrowable() == null && (!context.getZuulResponseHeaders().isEmpty() || context.getResponseDataStream() != null || context.getResponseBody() != null);
    }

    public Object run() {
        try {
            this.addResponseHeaders();
            this.writeResponse();
        }
        catch (Exception ex) {
            ReflectionUtils.rethrowRuntimeException((Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse() throws Exception {
        RequestContext context = RequestContext.getCurrentContext();
        if (context.getResponseBody() == null && context.getResponseDataStream() == null) {
            return;
        }
        HttpServletResponse servletResponse = context.getResponse();
        if (servletResponse.getCharacterEncoding() == null) {
            servletResponse.setCharacterEncoding("UTF-8");
        }
        ServletOutputStream outStream = servletResponse.getOutputStream();
        InputStream is = null;
        try {
            if (context.getResponseBody() != null) {
                String body = context.getResponseBody();
                is = new ByteArrayInputStream(body.getBytes(servletResponse.getCharacterEncoding()));
            } else {
                is = context.getResponseDataStream();
                if (is != null && context.getResponseGZipped()) {
                    if (this.isGzipRequested(context)) {
                        servletResponse.setHeader("Content-Encoding", "gzip");
                    } else {
                        is = this.handleGzipStream(is);
                    }
                }
            }
            if (is != null) {
                this.writeResponse(is, (OutputStream)outStream);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {
                    log.warn((Object)"Error while closing upstream input stream", (Throwable)ex);
                }
            }
            try {
                Object zuulResponse = context.get((Object)"zuulResponse");
                if (zuulResponse instanceof Closeable) {
                    ((Closeable)zuulResponse).close();
                }
                outStream.flush();
            }
            catch (IOException ex) {
                log.warn((Object)("Error while sending response to client: " + ex.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream handleGzipStream(InputStream in) throws Exception {
        RecordingInputStream stream = new RecordingInputStream(in);
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(stream);
            return gZIPInputStream;
        }
        catch (EOFException | ZipException ex) {
            if (stream.getBytesRead() == 0) {
                InputStream inputStream = in;
                return inputStream;
            }
            log.warn((Object)("gzip response expected but failed to read gzip headers, assuming unencoded response for request " + RequestContext.getCurrentContext().getRequest().getRequestURL().toString()));
            stream.reset();
            RecordingInputStream recordingInputStream = stream;
            return recordingInputStream;
        }
        finally {
            stream.stopRecording();
        }
    }

    protected boolean isGzipRequested(RequestContext context) {
        String requestEncoding = context.getRequest().getHeader("accept-encoding");
        return requestEncoding != null && HTTPRequestUtils.getInstance().isGzipped(requestEncoding);
    }

    private void writeResponse(InputStream zin, OutputStream out) throws Exception {
        byte[] bytes = this.buffers.get();
        int bytesRead = -1;
        while ((bytesRead = zin.read(bytes)) != -1) {
            out.write(bytes, 0, bytesRead);
        }
    }

    private void addResponseHeaders() {
        List zuulResponseHeaders;
        List rd;
        RequestContext context = RequestContext.getCurrentContext();
        HttpServletResponse servletResponse = context.getResponse();
        if (this.zuulProperties.isIncludeDebugHeader() && (rd = (List)context.get((Object)"routingDebug")) != null) {
            StringBuilder debugHeader = new StringBuilder();
            for (String it : rd) {
                debugHeader.append("[[[" + it + "]]]");
            }
            servletResponse.addHeader("X-Zuul-Debug-Header", debugHeader.toString());
        }
        if ((zuulResponseHeaders = context.getZuulResponseHeaders()) != null) {
            for (Pair it : zuulResponseHeaders) {
                servletResponse.addHeader((String)it.first(), (String)it.second());
            }
        }
        if (this.includeContentLengthHeader(context)) {
            Long contentLength = context.getOriginContentLength();
            if (this.useServlet31) {
                servletResponse.setContentLengthLong(contentLength.longValue());
            } else if (this.isLongSafe(contentLength)) {
                servletResponse.setContentLength(contentLength.intValue());
            }
        }
    }

    private boolean isLongSafe(long value) {
        return value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE;
    }

    protected boolean includeContentLengthHeader(RequestContext context) {
        if (!this.zuulProperties.isSetContentLength()) {
            return false;
        }
        if (context.getOriginContentLength() == null) {
            return false;
        }
        if (context.getResponseGZipped()) {
            return context.isGzipRequested();
        }
        return true;
    }

    private static class RecordingInputStream
    extends InputStream {
        private InputStream delegate;
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        public RecordingInputStream(InputStream delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public int read() throws IOException {
            int read = this.delegate.read();
            if (this.buffer != null && read != -1) {
                this.buffer.write(read);
            }
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.delegate.read(b, off, len);
            if (this.buffer != null && read != -1) {
                this.buffer.write(b, off, read);
            }
            return read;
        }

        @Override
        public void reset() {
            if (this.buffer == null) {
                throw new IllegalStateException("Stream is not recording");
            }
            this.delegate = new SequenceInputStream(new ByteArrayInputStream(this.buffer.toByteArray()), this.delegate);
            this.buffer = new ByteArrayOutputStream();
        }

        public int getBytesRead() {
            return this.buffer == null ? -1 : this.buffer.size();
        }

        public void stopRecording() {
            this.buffer = null;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

