/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.support;

import feign.Request;
import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.FeignUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.protobuf.ProtobufHttpMessageConverter;
import org.springframework.web.multipart.MultipartFile;

public class SpringEncoder
implements Encoder {
    private static final Log log = LogFactory.getLog(SpringEncoder.class);
    private final SpringFormEncoder springFormEncoder = new SpringFormEncoder();
    private final ObjectFactory<HttpMessageConverters> messageConverters;

    public SpringEncoder(ObjectFactory<HttpMessageConverters> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void encode(Object requestBody, Type bodyType, RequestTemplate request) throws EncodeException {
        if (requestBody != null) {
            Collection contentTypes = (Collection)request.headers().get("Content-Type");
            MediaType requestContentType = null;
            if (contentTypes != null && !contentTypes.isEmpty()) {
                String type = (String)contentTypes.iterator().next();
                requestContentType = MediaType.valueOf((String)type);
            }
            if (Objects.equals(requestContentType, MediaType.MULTIPART_FORM_DATA)) {
                this.springFormEncoder.encode(requestBody, bodyType, request);
                return;
            }
            if (bodyType == MultipartFile.class) {
                log.warn((Object)"For MultipartFile to be handled correctly, the 'consumes' parameter of @RequestMapping should be specified as MediaType.MULTIPART_FORM_DATA_VALUE");
            }
            for (HttpMessageConverter messageConverter : ((HttpMessageConverters)this.messageConverters.getObject()).getConverters()) {
                FeignOutputMessage outputMessage;
                try {
                    outputMessage = messageConverter instanceof GenericHttpMessageConverter ? this.checkAndWrite(requestBody, bodyType, requestContentType, (GenericHttpMessageConverter)messageConverter, request) : this.checkAndWrite(requestBody, requestContentType, messageConverter, request);
                }
                catch (IOException | HttpMessageConversionException ex) {
                    throw new EncodeException("Error converting request body", ex);
                }
                if (outputMessage == null) continue;
                request.headers(null);
                request.headers(FeignUtils.getHeaders(outputMessage.getHeaders()));
                Object charset = messageConverter instanceof ByteArrayHttpMessageConverter ? null : (messageConverter instanceof ProtobufHttpMessageConverter && ProtobufHttpMessageConverter.PROTOBUF.isCompatibleWith(outputMessage.getHeaders().getContentType()) ? null : StandardCharsets.UTF_8);
                request.body(Request.Body.encoded((byte[])outputMessage.getOutputStream().toByteArray(), (Charset)charset));
                return;
            }
            String message = "Could not write request: no suitable HttpMessageConverter found for request type [" + requestBody.getClass().getName() + "]";
            if (requestContentType != null) {
                message = message + " and content type [" + requestContentType + "]";
            }
            throw new EncodeException(message);
        }
    }

    private FeignOutputMessage checkAndWrite(Object body, MediaType contentType, HttpMessageConverter converter, RequestTemplate request) throws IOException {
        if (converter.canWrite(body.getClass(), contentType)) {
            this.logBeforeWrite(body, contentType, converter);
            FeignOutputMessage outputMessage = new FeignOutputMessage(request);
            converter.write(body, contentType, (HttpOutputMessage)outputMessage);
            return outputMessage;
        }
        return null;
    }

    private FeignOutputMessage checkAndWrite(Object body, Type genericType, MediaType contentType, GenericHttpMessageConverter converter, RequestTemplate request) throws IOException {
        if (converter.canWrite(genericType, body.getClass(), contentType)) {
            this.logBeforeWrite(body, contentType, (HttpMessageConverter)converter);
            FeignOutputMessage outputMessage = new FeignOutputMessage(request);
            converter.write(body, genericType, contentType, (HttpOutputMessage)outputMessage);
            return outputMessage;
        }
        return null;
    }

    private void logBeforeWrite(Object requestBody, MediaType requestContentType, HttpMessageConverter messageConverter) {
        if (log.isDebugEnabled()) {
            if (requestContentType != null) {
                log.debug((Object)("Writing [" + requestBody + "] as \"" + requestContentType + "\" using [" + messageConverter + "]"));
            } else {
                log.debug((Object)("Writing [" + requestBody + "] using [" + messageConverter + "]"));
            }
        }
    }

    private final class FeignOutputMessage
    implements HttpOutputMessage {
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        private final HttpHeaders httpHeaders;

        private FeignOutputMessage(RequestTemplate request) {
            this.httpHeaders = FeignUtils.getHttpHeaders(request.headers());
        }

        public OutputStream getBody() throws IOException {
            return this.outputStream;
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public ByteArrayOutputStream getOutputStream() {
            return this.outputStream;
        }
    }
}

