/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.expression.Expression;
import org.springframework.integration.config.AbstractStandardMessageHandlerFactoryBean;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.handler.ServiceActivatingHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.StringUtils;

public class ServiceActivatorFactoryBean
extends AbstractStandardMessageHandlerFactoryBean {
    private volatile Long sendTimeout;
    private volatile Boolean requiresReply;

    public void setSendTimeout(Long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setRequiresReply(Boolean requiresReply) {
        this.requiresReply = requiresReply;
    }

    @Override
    protected MessageHandler createMethodInvokingHandler(Object targetObject, String targetMethodName) {
        MessageHandler handler = null;
        handler = this.createDirectHandlerIfPossible(targetObject, targetMethodName);
        if (handler == null) {
            handler = this.configureHandler(StringUtils.hasText((String)targetMethodName) ? new ServiceActivatingHandler(targetObject, targetMethodName) : new ServiceActivatingHandler(targetObject));
        }
        return handler;
    }

    protected MessageHandler createDirectHandlerIfPossible(final Object targetObject, String targetMethodName) {
        AbstractReplyProducingMessageHandler handler = null;
        if (targetObject instanceof MessageHandler && this.methodIsHandleMessageOrEmpty(targetMethodName)) {
            if (targetObject instanceof AbstractMessageProducingHandler) {
                return (MessageHandler)targetObject;
            }
            handler = new AbstractReplyProducingMessageHandler(){

                @Override
                protected Object handleRequestMessage(Message<?> requestMessage) {
                    ((MessageHandler)targetObject).handleMessage(requestMessage);
                    return null;
                }
            };
        }
        return handler;
    }

    @Override
    protected MessageHandler createExpressionEvaluatingHandler(Expression expression) {
        ExpressionEvaluatingMessageProcessor processor = new ExpressionEvaluatingMessageProcessor(expression);
        processor.setBeanFactory(this.getBeanFactory());
        ServiceActivatingHandler handler = new ServiceActivatingHandler(processor);
        handler.setPrimaryExpression(expression);
        return this.configureHandler(handler);
    }

    @Override
    protected <T> MessageHandler createMessageProcessingHandler(MessageProcessor<T> processor) {
        return this.configureHandler(new ServiceActivatingHandler(processor));
    }

    protected MessageHandler configureHandler(ServiceActivatingHandler handler) {
        this.postProcessReplyProducer(handler);
        return handler;
    }

    @Override
    protected boolean canBeUsedDirect(AbstractMessageProducingHandler handler) {
        return true;
    }

    @Override
    protected void postProcessReplyProducer(AbstractMessageProducingHandler handler) {
        if (this.sendTimeout != null) {
            handler.setSendTimeout(this.sendTimeout);
        }
        if (this.requiresReply != null) {
            if (handler instanceof AbstractReplyProducingMessageHandler) {
                ((AbstractReplyProducingMessageHandler)handler).setRequiresReply(this.requiresReply);
            } else if (this.requiresReply.booleanValue() && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("requires-reply can only be set to AbstractReplyProducingMessageHandler or its subclass, " + handler.getComponentName() + " doesn't support it."));
            }
        }
    }
}

