/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.context;

import java.io.IOException;
import java.util.Properties;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class IntegrationProperties {
    public static final String INTEGRATION_PROPERTIES_PREFIX = "spring.integration.";
    public static final String CHANNELS_AUTOCREATE = "spring.integration.channels.autoCreate";
    public static final String CHANNELS_MAX_UNICAST_SUBSCRIBERS = "spring.integration.channels.maxUnicastSubscribers";
    public static final String CHANNELS_MAX_BROADCAST_SUBSCRIBERS = "spring.integration.channels.maxBroadcastSubscribers";
    public static final String TASK_SCHEDULER_POOL_SIZE = "spring.integration.taskScheduler.poolSize";
    public static final String THROW_EXCEPTION_ON_LATE_REPLY = "spring.integration.messagingTemplate.throwExceptionOnLateReply";
    public static final String REQUIRE_COMPONENT_ANNOTATION = "spring.integration.messagingAnnotations.require.componentAnnotation";
    public static final String GATEWAY_CONVERT_RECEIVE_MESSAGE = "spring.integration.messagingGateway.convertReceiveMessage";
    public static final String READ_ONLY_HEADERS = "spring.integration.readOnly.headers";
    public static final String ENDPOINTS_NO_AUTO_STARTUP = "spring.integration.endpoints.noAutoStartup";
    private static Properties defaults;

    public static Properties defaults() {
        return defaults;
    }

    public static String getExpressionFor(String key) {
        if (defaults.containsKey(key)) {
            return "#{T(org.springframework.integration.context.IntegrationContextUtils).getIntegrationProperties(beanFactory).getProperty('" + key + "')}";
        }
        throw new IllegalArgumentException("The provided key [" + key + "] isn't the one of Integration properties: " + defaults.keySet());
    }

    private IntegrationProperties() {
    }

    static {
        String resourcePattern = "classpath*:META-INF/spring.integration.default.properties";
        try {
            PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver(IntegrationProperties.class.getClassLoader());
            Resource[] defaultResources = resourceResolver.getResources(resourcePattern);
            PropertiesFactoryBean propertiesFactoryBean = new PropertiesFactoryBean();
            propertiesFactoryBean.setLocations(defaultResources);
            propertiesFactoryBean.afterPropertiesSet();
            defaults = propertiesFactoryBean.getObject();
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't load '" + resourcePattern + "' resources.", e);
        }
    }
}

