/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint;

import javax.xml.namespace.QName;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.server.endpoint.AbstractSoapFaultDefinitionExceptionResolver;
import org.springframework.ws.soap.server.endpoint.SoapFaultDefinition;
import org.springframework.ws.soap.server.endpoint.annotation.FaultCode;
import org.springframework.ws.soap.server.endpoint.annotation.SoapFault;

public class SoapFaultAnnotationExceptionResolver
extends AbstractSoapFaultDefinitionExceptionResolver {
    @Override
    protected final SoapFaultDefinition getFaultDefinition(Object endpoint, Exception ex) {
        SoapFault faultAnnotation = ex.getClass().getAnnotation(SoapFault.class);
        if (faultAnnotation != null) {
            SoapFaultDefinition definition = new SoapFaultDefinition();
            if (faultAnnotation.faultCode() != FaultCode.CUSTOM) {
                definition.setFaultCode(faultAnnotation.faultCode().value());
            } else if (StringUtils.hasLength((String)faultAnnotation.customFaultCode())) {
                definition.setFaultCode(QName.valueOf(faultAnnotation.customFaultCode()));
            }
            definition.setFaultStringOrReason(faultAnnotation.faultStringOrReason());
            definition.setLocale(StringUtils.parseLocaleString((String)faultAnnotation.locale()));
            return definition;
        }
        return null;
    }
}

