/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayOpenAuthAppAesGetDefaultResponse;
import com.alipay.v3.model.AlipayOpenAuthAppAesGetResponseModel;
import com.alipay.v3.model.AlipayOpenAuthAppAesSetDefaultResponse;
import com.alipay.v3.model.AlipayOpenAuthAppAesSetModel;
import com.alipay.v3.model.AlipayOpenAuthAppAesSetResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayOpenAuthAppAesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayOpenAuthAppAesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayOpenAuthAppAesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getCall(String merchantAppId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/auth/app/aes/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (merchantAppId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("merchant_app_id", merchantAppId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getValidateBeforeCall(String merchantAppId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.getCall(merchantAppId, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenAuthAppAesGetResponseModel get(String merchantAppId) throws ApiException {
        ApiResponse<AlipayOpenAuthAppAesGetResponseModel> localVarResp = this.getWithHttpInfo(merchantAppId, null);
        return localVarResp.getData();
    }

    public AlipayOpenAuthAppAesGetResponseModel get(String merchantAppId, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenAuthAppAesGetResponseModel> localVarResp = this.getWithHttpInfo(merchantAppId, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenAuthAppAesGetResponseModel> getWithHttpInfo(String merchantAppId, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.getValidateBeforeCall(merchantAppId, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenAuthAppAesGetResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenAuthAppAesGetDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call getAsync(String merchantAppId, ApiCallback<AlipayOpenAuthAppAesGetResponseModel> _callback) throws ApiException {
        Call localVarCall = this.getValidateBeforeCall(merchantAppId, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenAuthAppAesGetResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call getAsync(String merchantAppId, ApiCallback<AlipayOpenAuthAppAesGetResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.getValidateBeforeCall(merchantAppId, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenAuthAppAesGetResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setCall(AlipayOpenAuthAppAesSetModel alipayOpenAuthAppAesSetModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayOpenAuthAppAesSetModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayOpenAuthAppAesSetModel;
        String localVarPath = "/v3/alipay/open/auth/app/aes/set";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setValidateBeforeCall(AlipayOpenAuthAppAesSetModel alipayOpenAuthAppAesSetModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.setCall(alipayOpenAuthAppAesSetModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenAuthAppAesSetResponseModel set(AlipayOpenAuthAppAesSetModel alipayOpenAuthAppAesSetModel) throws ApiException {
        ApiResponse<AlipayOpenAuthAppAesSetResponseModel> localVarResp = this.setWithHttpInfo(alipayOpenAuthAppAesSetModel, null);
        return localVarResp.getData();
    }

    public AlipayOpenAuthAppAesSetResponseModel set(AlipayOpenAuthAppAesSetModel alipayOpenAuthAppAesSetModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenAuthAppAesSetResponseModel> localVarResp = this.setWithHttpInfo(alipayOpenAuthAppAesSetModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenAuthAppAesSetResponseModel> setWithHttpInfo(AlipayOpenAuthAppAesSetModel alipayOpenAuthAppAesSetModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.setValidateBeforeCall(alipayOpenAuthAppAesSetModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenAuthAppAesSetResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenAuthAppAesSetDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call setAsync(AlipayOpenAuthAppAesSetModel alipayOpenAuthAppAesSetModel, ApiCallback<AlipayOpenAuthAppAesSetResponseModel> _callback) throws ApiException {
        Call localVarCall = this.setValidateBeforeCall(alipayOpenAuthAppAesSetModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenAuthAppAesSetResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call setAsync(AlipayOpenAuthAppAesSetModel alipayOpenAuthAppAesSetModel, ApiCallback<AlipayOpenAuthAppAesSetResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.setValidateBeforeCall(alipayOpenAuthAppAesSetModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenAuthAppAesSetResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

