/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.KeySequence;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.session.Configuration;

public class TableInfo {
    private IdType idType = IdType.NONE;
    private DbType dbType;
    private String tableName;
    private String resultMap;
    private boolean keyRelated = false;
    private String keyProperty;
    private String keyColumn;
    private KeySequence keySequence;
    private List<TableFieldInfo> fieldList;
    private String currentNamespace;
    private String configMark;
    private boolean logicDelete = false;
    private boolean underCamel = true;
    private Class<?> clazz;
    private String allSqlSelect;
    private String sqlSelect;

    public String getSqlStatement(String sqlMethod) {
        return this.currentNamespace + "." + sqlMethod;
    }

    public void setConfigMark(Configuration configuration) {
        Assert.notNull(configuration, "Error: You need Initialize MybatisConfiguration !");
        this.configMark = configuration.toString();
    }

    public void setLogicDelete(boolean logicDelete) {
        if (logicDelete) {
            this.logicDelete = true;
        }
    }

    public String getKeySqlSelect() {
        if (this.sqlSelect != null) {
            return this.sqlSelect;
        }
        this.sqlSelect = StringUtils.isNotEmpty(this.keyProperty) ? (this.keyRelated ? SqlUtils.sqlWordConvert(this.dbType, this.keyColumn, true) + " AS " + SqlUtils.sqlWordConvert(this.dbType, this.keyProperty, false) : SqlUtils.sqlWordConvert(this.dbType, this.keyColumn, true)) : "";
        return this.sqlSelect;
    }

    public String getAllSqlSelect() {
        if (this.allSqlSelect != null) {
            return this.allSqlSelect;
        }
        String sqlSelect = this.getKeySqlSelect();
        String fieldsSqlSelect = this.fieldList.stream().filter(TableFieldInfo::isSelect).map(i -> i.getSqlSelect(this.dbType)).collect(Collectors.joining(","));
        this.allSqlSelect = StringUtils.isNotEmpty(sqlSelect) && StringUtils.isNotEmpty(fieldsSqlSelect) ? sqlSelect + "," + fieldsSqlSelect : (StringUtils.isNotEmpty(fieldsSqlSelect) ? fieldsSqlSelect : sqlSelect);
        return this.allSqlSelect;
    }

    public String getKeyInsertSqlProperty() {
        if (StringUtils.isNotEmpty(this.keyProperty)) {
            if (this.idType == IdType.AUTO) {
                return "";
            }
            return SqlScriptUtils.safeParam(this.keyProperty) + "," + "\n";
        }
        return "";
    }

    public String getKeyInsertSqlColumn() {
        if (StringUtils.isNotEmpty(this.keyColumn)) {
            if (this.idType == IdType.AUTO) {
                return "";
            }
            return this.keyColumn + "," + "\n";
        }
        return "";
    }

    public String getAllInsertSqlProperty() {
        return this.getKeyInsertSqlProperty() + this.fieldList.stream().map(TableFieldInfo::getInsertSqlProperty).collect(Collectors.joining("\n"));
    }

    public String getAllInsertSqlColumn() {
        return this.getKeyInsertSqlColumn() + this.fieldList.stream().map(TableFieldInfo::getInsertSqlColumn).collect(Collectors.joining("\n"));
    }

    public String getAllSqlWhere(boolean ignoreLogicDelFiled, boolean withId, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String filedSqlScript = this.fieldList.stream().filter(i -> {
            if (ignoreLogicDelFiled) {
                return !this.isLogicDelete() || !i.isLogicDelete();
            }
            return true;
        }).map(i -> i.getSqlWhere(newPrefix)).collect(Collectors.joining("\n"));
        if (!withId) {
            return filedSqlScript;
        }
        String newKeyProperty = newPrefix + this.keyProperty;
        String keySqlScript = this.keyColumn + "=" + SqlScriptUtils.safeParam(newKeyProperty);
        return SqlScriptUtils.convertIf(keySqlScript, String.format("%s != null", newKeyProperty), false) + "\n" + filedSqlScript;
    }

    public String getAllSqlSet(boolean ignoreLogicDelFiled, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        return this.fieldList.stream().filter(i -> {
            if (ignoreLogicDelFiled) {
                return !this.isLogicDelete() || !i.isLogicDelete();
            }
            return true;
        }).map(i -> i.getSqlSet(newPrefix)).collect(Collectors.joining("\n"));
    }

    public String getLogicDeleteSql(boolean startWithAnd, boolean deleteValue) {
        if (this.isLogicDelete()) {
            TableFieldInfo field = this.fieldList.stream().filter(TableFieldInfo::isLogicDelete).findFirst().orElseThrow(() -> ExceptionUtils.mpe(String.format("can't find the logicFiled from table {%s}", this.tableName)));
            String formatStr = field.isCharSequence() ? "'%s'" : "%s";
            String logicDeleteSql = field.getColumn() + "=" + String.format(formatStr, deleteValue ? field.getLogicDeleteValue() : field.getLogicNotDeleteValue());
            if (startWithAnd) {
                logicDeleteSql = " AND " + logicDeleteSql;
            }
            return logicDeleteSql;
        }
        return "";
    }

    public IdType getIdType() {
        return this.idType;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getResultMap() {
        return this.resultMap;
    }

    public boolean isKeyRelated() {
        return this.keyRelated;
    }

    public String getKeyProperty() {
        return this.keyProperty;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public KeySequence getKeySequence() {
        return this.keySequence;
    }

    public List<TableFieldInfo> getFieldList() {
        return this.fieldList;
    }

    public String getCurrentNamespace() {
        return this.currentNamespace;
    }

    public String getConfigMark() {
        return this.configMark;
    }

    public boolean isLogicDelete() {
        return this.logicDelete;
    }

    public boolean isUnderCamel() {
        return this.underCamel;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getSqlSelect() {
        return this.sqlSelect;
    }

    public TableInfo setIdType(IdType idType) {
        this.idType = idType;
        return this;
    }

    public TableInfo setDbType(DbType dbType) {
        this.dbType = dbType;
        return this;
    }

    public TableInfo setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TableInfo setResultMap(String resultMap) {
        this.resultMap = resultMap;
        return this;
    }

    public TableInfo setKeyRelated(boolean keyRelated) {
        this.keyRelated = keyRelated;
        return this;
    }

    public TableInfo setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
        return this;
    }

    public TableInfo setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
        return this;
    }

    public TableInfo setKeySequence(KeySequence keySequence) {
        this.keySequence = keySequence;
        return this;
    }

    public TableInfo setFieldList(List<TableFieldInfo> fieldList) {
        this.fieldList = fieldList;
        return this;
    }

    public TableInfo setCurrentNamespace(String currentNamespace) {
        this.currentNamespace = currentNamespace;
        return this;
    }

    public TableInfo setUnderCamel(boolean underCamel) {
        this.underCamel = underCamel;
        return this;
    }

    public TableInfo setClazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableInfo)) {
            return false;
        }
        TableInfo other = (TableInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IdType this$idType = this.getIdType();
        IdType other$idType = other.getIdType();
        if (this$idType == null ? other$idType != null : !this$idType.equals(other$idType)) {
            return false;
        }
        DbType this$dbType = this.getDbType();
        DbType other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !this$dbType.equals(other$dbType)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$resultMap = this.getResultMap();
        String other$resultMap = other.getResultMap();
        if (this$resultMap == null ? other$resultMap != null : !this$resultMap.equals(other$resultMap)) {
            return false;
        }
        if (this.isKeyRelated() != other.isKeyRelated()) {
            return false;
        }
        String this$keyProperty = this.getKeyProperty();
        String other$keyProperty = other.getKeyProperty();
        if (this$keyProperty == null ? other$keyProperty != null : !this$keyProperty.equals(other$keyProperty)) {
            return false;
        }
        String this$keyColumn = this.getKeyColumn();
        String other$keyColumn = other.getKeyColumn();
        if (this$keyColumn == null ? other$keyColumn != null : !this$keyColumn.equals(other$keyColumn)) {
            return false;
        }
        KeySequence this$keySequence = this.getKeySequence();
        KeySequence other$keySequence = other.getKeySequence();
        if (this$keySequence == null ? other$keySequence != null : !this$keySequence.equals(other$keySequence)) {
            return false;
        }
        List<TableFieldInfo> this$fieldList = this.getFieldList();
        List<TableFieldInfo> other$fieldList = other.getFieldList();
        if (this$fieldList == null ? other$fieldList != null : !((Object)this$fieldList).equals(other$fieldList)) {
            return false;
        }
        String this$currentNamespace = this.getCurrentNamespace();
        String other$currentNamespace = other.getCurrentNamespace();
        if (this$currentNamespace == null ? other$currentNamespace != null : !this$currentNamespace.equals(other$currentNamespace)) {
            return false;
        }
        String this$configMark = this.getConfigMark();
        String other$configMark = other.getConfigMark();
        if (this$configMark == null ? other$configMark != null : !this$configMark.equals(other$configMark)) {
            return false;
        }
        if (this.isLogicDelete() != other.isLogicDelete()) {
            return false;
        }
        if (this.isUnderCamel() != other.isUnderCamel()) {
            return false;
        }
        Class<?> this$clazz = this.getClazz();
        Class<?> other$clazz = other.getClazz();
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        String this$allSqlSelect = this.getAllSqlSelect();
        String other$allSqlSelect = other.getAllSqlSelect();
        if (this$allSqlSelect == null ? other$allSqlSelect != null : !this$allSqlSelect.equals(other$allSqlSelect)) {
            return false;
        }
        String this$sqlSelect = this.getSqlSelect();
        String other$sqlSelect = other.getSqlSelect();
        return !(this$sqlSelect == null ? other$sqlSelect != null : !this$sqlSelect.equals(other$sqlSelect));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IdType $idType = this.getIdType();
        result = result * 59 + ($idType == null ? 43 : $idType.hashCode());
        DbType $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : $dbType.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $resultMap = this.getResultMap();
        result = result * 59 + ($resultMap == null ? 43 : $resultMap.hashCode());
        result = result * 59 + (this.isKeyRelated() ? 79 : 97);
        String $keyProperty = this.getKeyProperty();
        result = result * 59 + ($keyProperty == null ? 43 : $keyProperty.hashCode());
        String $keyColumn = this.getKeyColumn();
        result = result * 59 + ($keyColumn == null ? 43 : $keyColumn.hashCode());
        KeySequence $keySequence = this.getKeySequence();
        result = result * 59 + ($keySequence == null ? 43 : $keySequence.hashCode());
        List<TableFieldInfo> $fieldList = this.getFieldList();
        result = result * 59 + ($fieldList == null ? 43 : ((Object)$fieldList).hashCode());
        String $currentNamespace = this.getCurrentNamespace();
        result = result * 59 + ($currentNamespace == null ? 43 : $currentNamespace.hashCode());
        String $configMark = this.getConfigMark();
        result = result * 59 + ($configMark == null ? 43 : $configMark.hashCode());
        result = result * 59 + (this.isLogicDelete() ? 79 : 97);
        result = result * 59 + (this.isUnderCamel() ? 79 : 97);
        Class<?> $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        String $allSqlSelect = this.getAllSqlSelect();
        result = result * 59 + ($allSqlSelect == null ? 43 : $allSqlSelect.hashCode());
        String $sqlSelect = this.getSqlSelect();
        result = result * 59 + ($sqlSelect == null ? 43 : $sqlSelect.hashCode());
        return result;
    }

    public String toString() {
        return "TableInfo(idType=" + this.getIdType() + ", dbType=" + this.getDbType() + ", tableName=" + this.getTableName() + ", resultMap=" + this.getResultMap() + ", keyRelated=" + this.isKeyRelated() + ", keyProperty=" + this.getKeyProperty() + ", keyColumn=" + this.getKeyColumn() + ", keySequence=" + this.getKeySequence() + ", fieldList=" + this.getFieldList() + ", currentNamespace=" + this.getCurrentNamespace() + ", configMark=" + this.getConfigMark() + ", logicDelete=" + this.isLogicDelete() + ", underCamel=" + this.isUnderCamel() + ", clazz=" + this.getClazz() + ", allSqlSelect=" + this.getAllSqlSelect() + ", sqlSelect=" + this.getSqlSelect() + ")";
    }
}

