/*
 * Decompiled with CFR 0.152.
 */
package javapns.communication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.KeyStore;
import javapns.communication.AppleServer;
import javapns.communication.KeystoreManager;
import javapns.communication.ProxyManager;
import javapns.communication.ServerTrustingTrustManager;
import javapns.communication.exceptions.CommunicationException;
import javapns.communication.exceptions.KeystoreException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionToAppleServer {
    public static final String KEYSTORE_TYPE_PKCS12 = "PKCS12";
    public static final String KEYSTORE_TYPE_JKS = "JKS";
    private static final Logger logger = LoggerFactory.getLogger(ConnectionToAppleServer.class);
    private static final String ALGORITHM = KeyManagerFactory.getDefaultAlgorithm();
    private static final String PROTOCOL = "TLS";
    private final AppleServer server;
    private KeyStore keyStore;
    private SSLSocketFactory socketFactory;

    protected ConnectionToAppleServer(AppleServer server) throws KeystoreException {
        this.server = server;
        this.keyStore = KeystoreManager.loadKeystore(server);
    }

    protected ConnectionToAppleServer(AppleServer server, KeyStore keystore) {
        this.server = server;
        this.keyStore = keystore;
    }

    public AppleServer getServer() {
        return this.server;
    }

    private KeyStore getKeystore() {
        return this.keyStore;
    }

    public void setKeystore(KeyStore ks) {
        this.keyStore = ks;
    }

    private SSLSocketFactory createSSLSocketFactoryWithTrustManagers(TrustManager[] trustManagers) throws KeystoreException {
        logger.debug("Creating SSLSocketFactory");
        try {
            KeyStore keystore = this.getKeystore();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(ALGORITHM);
            try {
                char[] password = KeystoreManager.getKeystorePasswordForSSL(this.server);
                kmf.init(keystore, password);
            }
            catch (Exception e2) {
                KeystoreException e2 = KeystoreManager.wrapKeystoreException(e2);
                throw e2;
            }
            SSLContext sslc = SSLContext.getInstance(PROTOCOL);
            sslc.init(kmf.getKeyManagers(), trustManagers, null);
            return sslc.getSocketFactory();
        }
        catch (Exception e) {
            throw new KeystoreException("Keystore exception: " + e.getMessage(), e);
        }
    }

    public abstract String getServerHost();

    protected abstract int getServerPort();

    private SSLSocketFactory createSSLSocketFactory() throws KeystoreException {
        return this.createSSLSocketFactoryWithTrustManagers(new TrustManager[]{new ServerTrustingTrustManager()});
    }

    private SSLSocketFactory getSSLSocketFactory() throws KeystoreException {
        if (this.socketFactory == null) {
            this.socketFactory = this.createSSLSocketFactory();
        }
        return this.socketFactory;
    }

    public SSLSocket getSSLSocket() throws KeystoreException, CommunicationException {
        SSLSocketFactory socketFactory = this.getSSLSocketFactory();
        logger.debug("Creating SSLSocket to " + this.getServerHost() + ":" + this.getServerPort());
        try {
            if (ProxyManager.isUsingProxy(this.server)) {
                return this.tunnelThroughProxy(socketFactory);
            }
            return (SSLSocket)socketFactory.createSocket(this.getServerHost(), this.getServerPort());
        }
        catch (Exception e) {
            throw new CommunicationException("Communication exception: " + e, e);
        }
    }

    private SSLSocket tunnelThroughProxy(SSLSocketFactory socketFactory) throws IOException {
        String tunnelHost = ProxyManager.getProxyHost(this.server);
        Integer tunnelPort = ProxyManager.getProxyPort(this.server);
        Socket tunnel = new Socket(tunnelHost, (int)tunnelPort);
        this.doTunnelHandshake(tunnel, this.getServerHost(), this.getServerPort());
        SSLSocket socket = (SSLSocket)socketFactory.createSocket(tunnel, this.getServerHost(), this.getServerPort(), true);
        socket.addHandshakeCompletedListener(event -> {
            logger.debug("Handshake finished!");
            logger.debug("\t CipherSuite:" + event.getCipherSuite());
            logger.debug("\t SessionId " + event.getSession());
            logger.debug("\t PeerHost " + event.getSession().getPeerHost());
        });
        return socket;
    }

    private void doTunnelHandshake(Socket tunnel, String host, int port) throws IOException {
        String replyStr;
        byte[] b;
        OutputStream out = tunnel.getOutputStream();
        String msg = "CONNECT " + host + ":" + port + " HTTP/1.0\n" + "User-Agent: BoardPad Server" + "\r\n\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = msg.getBytes();
        }
        out.write(b);
        out.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = tunnel.getInputStream();
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if (!replyStr.toLowerCase().contains("200 connection established")) {
            throw new IOException("Unable to tunnel through. Proxy returns \"" + replyStr + "\"");
        }
    }
}

