/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionResult;
import com.microsoft.cognitiveservices.speech.translation.TranslationRecognitionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;

public final class AutoDetectSourceLanguageResult {
    private String _language;

    public static AutoDetectSourceLanguageResult fromResult(SpeechRecognitionResult speechRecognitionResult) {
        Contracts.throwIfNull(speechRecognitionResult, "speechRecognitionResult cannot be null");
        String string = speechRecognitionResult.getProperties().getProperty(PropertyId.SpeechServiceConnection_AutoDetectSourceLanguageResult);
        return new AutoDetectSourceLanguageResult(string);
    }

    public static AutoDetectSourceLanguageResult fromResult(TranslationRecognitionResult translationRecognitionResult) {
        Contracts.throwIfNull(translationRecognitionResult, "translationRecognitionResult cannot be null");
        String string = translationRecognitionResult.getProperties().getProperty(PropertyId.SpeechServiceConnection_AutoDetectSourceLanguageResult);
        return new AutoDetectSourceLanguageResult(string);
    }

    public String getLanguage() {
        return this._language;
    }

    private AutoDetectSourceLanguageResult(String string) {
        this._language = string;
    }
}

