/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.diagnostics.logging;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.diagnostics.logging.EventLogger;
import com.microsoft.cognitiveservices.speech.diagnostics.logging.Level;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.StringRef;

class Logger {
    Logger() {
    }

    public static void setMemoryLoggingFilters(String[] stringArray) {
        Contracts.throwIfNull(stringArray, "filters");
        Contracts.throwIfFail(Logger.logMemorySetFilters(String.join((CharSequence)";", stringArray)));
    }

    public static long getMemoryLogLineNumOldest() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(Logger.logMemoryGetLineNumOldest(intRef));
        return intRef.getValue();
    }

    public static long getMemoryLogLineNumNewest() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(Logger.logMemoryGetLineNumNewest(intRef));
        return intRef.getValue();
    }

    public static String getMemoryLogLine(long l) {
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(Logger.logMemoryGetLine(l, stringRef));
        return stringRef.getValue();
    }

    public static void fileLoggerSetFilters(String[] stringArray) {
        Contracts.throwIfNull(stringArray, "filters");
        Contracts.throwIfFail(Logger.logFileSetFilters(String.join((CharSequence)";", stringArray)));
    }

    public static void setLevel(Type type, Level level) {
        Contracts.throwIfNull((Object)type, "type");
        Contracts.throwIfNull((Object)level, "level");
        Contracts.throwIfFail(Logger.logSetLevel(type.name().toLowerCase(), level.name().toLowerCase()));
    }

    public static void setEventLoggingCallback(EventLogger.EventHandler eventHandler, long l) {
        Contracts.throwIfFail(Logger.logEventSetCallback(eventHandler, l));
    }

    public static void setEventLoggingFilters(String[] stringArray) {
        Contracts.throwIfNull(stringArray, "filters");
        Contracts.throwIfFail(Logger.logEventSetFilters(String.join((CharSequence)";", stringArray)));
    }

    private static final native long logMemorySetFilters(String var0);

    private static final native long logMemoryGetLineNumOldest(IntRef var0);

    private static final native long logMemoryGetLineNumNewest(IntRef var0);

    private static final native long logMemoryGetLine(long var0, StringRef var2);

    private static final native long logFileSetFilters(String var0);

    private static final native long logEventSetCallback(EventLogger.EventHandler var0, long var1);

    private static final native long logEventSetFilters(String var0);

    private static final native long logSetLevel(String var0, String var1);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }

    public static enum Type {
        File,
        Memory,
        Event;

    }
}

