/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.speaker;

import com.microsoft.cognitiveservices.speech.CancellationErrorCode;
import com.microsoft.cognitiveservices.speech.CancellationReason;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.speaker.SpeakerRecognitionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public class SpeakerRecognitionCancellationDetails {
    private CancellationReason reason;
    private String errorDetails;
    private CancellationErrorCode errorCode;

    public static SpeakerRecognitionCancellationDetails fromResult(SpeakerRecognitionResult speakerRecognitionResult) {
        return new SpeakerRecognitionCancellationDetails(speakerRecognitionResult);
    }

    private SpeakerRecognitionCancellationDetails(SpeakerRecognitionResult speakerRecognitionResult) {
        Contracts.throwIfNull(speakerRecognitionResult, "result");
        Contracts.throwIfNull(speakerRecognitionResult.getImpl(), "resultHandle");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getCanceledReason(speakerRecognitionResult.getImpl(), intRef));
        this.reason = CancellationReason.values()[(int)intRef.getValue() - 1];
        Contracts.throwIfFail(this.getCanceledErrorCode(speakerRecognitionResult.getImpl(), intRef));
        this.errorCode = CancellationErrorCode.values()[(int)intRef.getValue()];
        this.errorDetails = speakerRecognitionResult.getProperties().getProperty(PropertyId.SpeechServiceResponse_JsonErrorDetails);
    }

    public void close() {
    }

    public CancellationReason getReason() {
        return this.reason;
    }

    public CancellationErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "CancellationReason:" + (Object)((Object)this.reason) + " ErrorCode: " + (Object)((Object)this.errorCode) + " ErrorDetails:" + this.errorDetails;
    }

    private final native long getCanceledReason(SafeHandle var1, IntRef var2);

    private final native long getCanceledErrorCode(SafeHandle var1, IntRef var2);
}

