/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.translation;

import com.microsoft.cognitiveservices.speech.CancellationDetails;
import com.microsoft.cognitiveservices.speech.CancellationErrorCode;
import com.microsoft.cognitiveservices.speech.CancellationReason;
import com.microsoft.cognitiveservices.speech.translation.TranslationRecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.util.Contracts;

public final class TranslationRecognitionCanceledEventArgs
extends TranslationRecognitionEventArgs {
    private CancellationReason cancellationReason;
    private CancellationErrorCode errorCode;
    private String errorDetails;

    TranslationRecognitionCanceledEventArgs(long l) {
        super(l);
        this.storeEventData(false);
    }

    TranslationRecognitionCanceledEventArgs(long l, boolean bl) {
        super(l);
        this.storeEventData(bl);
    }

    public CancellationReason getReason() {
        return this.cancellationReason;
    }

    public CancellationErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    @Override
    public String toString() {
        return "SessionId:" + this.getSessionId() + " ResultId:" + this.getResult().getResultId() + " CancellationReason:" + (Object)((Object)this.cancellationReason) + " CancellationErrorCode:" + (Object)((Object)this.errorCode) + " Error details:" + this.errorDetails;
    }

    private void storeEventData(boolean bl) {
        Contracts.throwIfNull(this.eventHandle, "eventHandle");
        CancellationDetails cancellationDetails = CancellationDetails.fromResult(this.getResult());
        this.cancellationReason = cancellationDetails.getReason();
        this.errorCode = cancellationDetails.getErrorCode();
        this.errorDetails = cancellationDetails.getErrorDetails();
        if (bl) {
            super.close();
        }
    }
}

