/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.excel.aop;

import cn.idev.excel.EasyExcel;
import cn.idev.excel.converters.Converter;
import cn.idev.excel.read.builder.ExcelReaderBuilder;
import cn.idev.excel.read.builder.ExcelReaderSheetBuilder;
import cn.idev.excel.read.listener.ReadListener;
import com.pig4cloud.plugin.excel.annotation.RequestExcel;
import com.pig4cloud.plugin.excel.converters.DictTypeConvert;
import com.pig4cloud.plugin.excel.converters.LocalDateStringConverter;
import com.pig4cloud.plugin.excel.converters.LocalDateTimeStringConverter;
import com.pig4cloud.plugin.excel.converters.LocalTimeStringConverter;
import com.pig4cloud.plugin.excel.converters.LongStringConverter;
import com.pig4cloud.plugin.excel.converters.StringArrayConverter;
import com.pig4cloud.plugin.excel.handler.DictCacheClearAnalysisEventListener;
import com.pig4cloud.plugin.excel.handler.ListAnalysisEventListener;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;

public class RequestExcelArgumentResolver
implements HandlerMethodArgumentResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestExcelArgumentResolver.class);

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestExcel.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest webRequest, WebDataBinderFactory webDataBinderFactory) {
        Object inputStream;
        Class parameterType = parameter.getParameterType();
        if (!parameterType.isAssignableFrom(List.class)) {
            throw new IllegalArgumentException("Excel upload request resolver error, @RequestExcel parameter is not List " + parameterType);
        }
        RequestExcel requestExcel = (RequestExcel)parameter.getParameterAnnotation(RequestExcel.class);
        assert (requestExcel != null);
        Class<? extends ListAnalysisEventListener<?>> readListenerClass = requestExcel.readListener();
        ListAnalysisEventListener readListener = (ListAnalysisEventListener)((Object)BeanUtils.instantiateClass(readListenerClass));
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        assert (request != null);
        if (request instanceof MultipartRequest) {
            MultipartFile file = ((MultipartRequest)request).getFile(requestExcel.fileName());
            assert (file != null);
            inputStream = file.getInputStream();
        } else {
            inputStream = request.getInputStream();
        }
        Class excelModelClass = ResolvableType.forMethodParameter((MethodParameter)parameter).getGeneric(new int[]{0}).resolve();
        ((ExcelReaderSheetBuilder)((ExcelReaderBuilder)((ExcelReaderBuilder)((ExcelReaderBuilder)((ExcelReaderBuilder)((ExcelReaderBuilder)((ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)inputStream, (Class)excelModelClass, (ReadListener)readListener).registerConverter((Converter)LocalDateStringConverter.INSTANCE)).registerConverter((Converter)LocalDateTimeStringConverter.INSTANCE)).registerConverter((Converter)LocalTimeStringConverter.INSTANCE)).registerConverter((Converter)LongStringConverter.INSTANCE)).registerConverter((Converter)StringArrayConverter.INSTANCE)).registerConverter((Converter)DictTypeConvert.INSTANCE)).registerReadListener((ReadListener)new DictCacheClearAnalysisEventListener())).ignoreEmptyRow(Boolean.valueOf(requestExcel.ignoreEmptyRow())).sheet().headRowNumber(Integer.valueOf(requestExcel.headRowNumber()))).doRead();
        WebDataBinder dataBinder = webDataBinderFactory.createBinder(webRequest, readListener.getErrors(), "excel");
        ModelMap model = modelAndViewContainer.getModel();
        model.put((Object)(BindingResult.MODEL_KEY_PREFIX + "excel"), (Object)dataBinder.getBindingResult());
        return readListener.getList();
    }
}

