/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.excel.vo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public interface DictEnum {
    public String getValue();

    public String getLabel();

    default public boolean eq(Object o) {
        return this == o || Objects.equals(o, this.getValue());
    }

    public static <E extends DictEnum> String getLabelByValue(E[] enums, String value) {
        return Arrays.stream(enums).filter(e -> Objects.equals(e.getValue(), value)).map(DictEnum::getLabel).findFirst().orElse(null);
    }

    public static <E extends DictEnum> String getValueByLabel(E[] enums, String label) {
        return Arrays.stream(enums).filter(e -> Objects.equals(e.getLabel(), label)).map(DictEnum::getValue).findFirst().orElse(null);
    }

    public static DictEnum of(final String value, final String label) {
        return new DictEnum(){

            @Override
            public String getValue() {
                return value;
            }

            @Override
            public String getLabel() {
                return label;
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<DictEnum> items = new ArrayList<DictEnum>();

        public Builder add(String value, String label) {
            this.items.add(DictEnum.of(value, label));
            return this;
        }

        public DictEnum[] build() {
            return this.items.toArray(new DictEnum[0]);
        }
    }
}

