/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.freemarker.impl;

import freemarker.cache.NullCacheStorage;
import freemarker.template.Configuration;
import freemarker.template.Template;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.common.template.CachingTemplateEngine;
import io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine;
import io.vertx.ext.web.templ.freemarker.impl.FreeMarkerTemplateLoader;
import io.vertx.ext.web.templ.freemarker.impl.VertxWebObjectWrapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;

public class FreeMarkerTemplateEngineImpl
extends CachingTemplateEngine<Template>
implements FreeMarkerTemplateEngine {
    private final Configuration config = new Configuration(Configuration.VERSION_2_3_28);

    public FreeMarkerTemplateEngineImpl(Vertx vertx) {
        super("ftl", 10000);
        this.config.setObjectWrapper(new VertxWebObjectWrapper(this.config.getIncompatibleImprovements()));
        this.config.setTemplateLoader(new FreeMarkerTemplateLoader(vertx));
        this.config.setCacheStorage(new NullCacheStorage());
    }

    @Override
    public FreeMarkerTemplateEngine setExtension(String extension) {
        this.doSetExtension(extension);
        return this;
    }

    @Override
    public FreeMarkerTemplateEngine setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<String, Object> context, String templateFile, Handler<AsyncResult<Buffer>> handler) {
        try {
            Template template;
            Template template2 = template = this.isCachingEnabled() ? (Template)this.cache.get((Object)templateFile) : null;
            if (template == null) {
                FreeMarkerTemplateEngineImpl freeMarkerTemplateEngineImpl = this;
                synchronized (freeMarkerTemplateEngineImpl) {
                    template = this.config.getTemplate(this.adjustLocation(templateFile));
                }
                if (this.isCachingEnabled()) {
                    this.cache.put((Object)templateFile, (Object)template);
                }
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                template.process(context, new OutputStreamWriter(baos));
                handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((byte[])baos.toByteArray())));
            }
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }
}

