/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.Interface;
import org.activiti.bpmn.model.Operation;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SendTask;
import org.activiti.bpmn.model.Task;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.impl.ExternalInvocationTaskValidator;
import org.apache.commons.lang3.StringUtils;

public class SendTaskValidator
extends ExternalInvocationTaskValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List sendTasks = process.findFlowElementsOfType(SendTask.class);
        for (SendTask sendTask : sendTasks) {
            if (StringUtils.isEmpty((CharSequence)sendTask.getType()) && !ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE.equalsIgnoreCase(sendTask.getImplementationType())) {
                this.addError(errors, "activiti-sendtask-invalid-implementation", process, (BaseElement)sendTask, "One of the attributes 'type' or 'operation' is mandatory on sendTask");
            }
            if (StringUtils.isNotEmpty((CharSequence)sendTask.getType())) {
                if (!(sendTask.getType().equalsIgnoreCase("mail") || sendTask.getType().equalsIgnoreCase("mule") || sendTask.getType().equalsIgnoreCase("camel"))) {
                    this.addError(errors, "activiti-sendtask-invalid-type", process, (BaseElement)sendTask, "Invalid or unsupported type for send task");
                }
                if (sendTask.getType().equalsIgnoreCase("mail")) {
                    this.validateFieldDeclarationsForEmail(process, (Task)sendTask, sendTask.getFieldExtensions(), errors);
                }
            }
            this.verifyWebservice(bpmnModel, process, sendTask, errors);
        }
    }

    protected void verifyWebservice(BpmnModel bpmnModel, Process process, SendTask sendTask, List<ValidationError> errors) {
        if (ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE.equalsIgnoreCase(sendTask.getImplementationType()) && StringUtils.isNotEmpty((CharSequence)sendTask.getOperationRef())) {
            boolean operationFound = false;
            if (bpmnModel.getInterfaces() != null && bpmnModel.getInterfaces().size() > 0) {
                for (Interface bpmnInterface : bpmnModel.getInterfaces()) {
                    if (bpmnInterface.getOperations() == null || bpmnInterface.getOperations().size() <= 0) continue;
                    for (Operation operation : bpmnInterface.getOperations()) {
                        if (operation.getId() == null || !operation.getId().equals(sendTask.getOperationRef())) continue;
                        operationFound = true;
                    }
                }
            }
            if (!operationFound) {
                this.addError(errors, "activiti-send-webservice-invalid-operation-ref", process, (BaseElement)sendTask, "Invalid operation reference for send task");
            }
        }
    }
}

