/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class SqoopException
extends RuntimeException {
    private final ErrorCode code;
    private final String originalMessage;

    public SqoopException(ErrorCode code) {
        super(code.getCode() + ":" + code.getMessage());
        this.code = code;
        this.originalMessage = null;
    }

    public SqoopException(ErrorCode code, String extraInfo) {
        super(code.getCode() + ":" + code.getMessage() + " - " + extraInfo);
        this.code = code;
        this.originalMessage = extraInfo;
    }

    public SqoopException(ErrorCode code, Throwable cause) {
        super(code.getCode() + ":" + code.getMessage(), cause);
        this.code = code;
        this.originalMessage = null;
    }

    public SqoopException(ErrorCode code, String extraInfo, Throwable cause) {
        super(code.getCode() + ":" + code.getMessage() + " - " + extraInfo, cause);
        this.code = code;
        this.originalMessage = extraInfo;
    }

    public ErrorCode getErrorCode() {
        return this.code;
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }
}

