/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.json.util.SerializationError;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JSONUtils {
    public static JSONObject parse(String input) {
        try {
            return (JSONObject)JSONValue.parseWithException((String)input);
        }
        catch (ParseException e) {
            throw new SqoopException((ErrorCode)SerializationError.SERIALIZATION_002, (Throwable)e);
        }
    }

    public static JSONObject parse(Reader reader) {
        try {
            return (JSONObject)JSONValue.parseWithException((Reader)reader);
        }
        catch (ParseException e) {
            throw new SqoopException((ErrorCode)SerializationError.SERIALIZATION_002, (Throwable)e);
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)SerializationError.SERIALIZATION_002, (Throwable)e);
        }
    }

    public static <T> T getType(JSONObject jsonObject, String key, Class<T> targetClass) {
        if (!jsonObject.containsKey((Object)key)) {
            throw new SqoopException((ErrorCode)SerializationError.SERIALIZATION_003, "Key: " + key);
        }
        Object ret = jsonObject.get((Object)key);
        if (ret == null) {
            return null;
        }
        if (!targetClass.isInstance(ret)) {
            throw new SqoopException((ErrorCode)SerializationError.SERIALIZATION_004, "Found " + ret.getClass().getName() + " instead of " + targetClass.getName() + " for key: " + key);
        }
        return (T)ret;
    }

    public static Long getLong(JSONObject jsonObject, String key) {
        return JSONUtils.getType(jsonObject, key, Long.class);
    }

    public static JSONObject getJSONObject(JSONObject jsonObject, String key) {
        return JSONUtils.getType(jsonObject, key, JSONObject.class);
    }

    public static JSONArray getJSONArray(JSONObject jsonObject, String key) {
        return JSONUtils.getType(jsonObject, key, JSONArray.class);
    }

    public static String getString(JSONObject jsonObject, String key) {
        return JSONUtils.getType(jsonObject, key, String.class);
    }

    public static Boolean getBoolean(JSONObject jsonObject, String key) {
        return JSONUtils.getType(jsonObject, key, Boolean.class);
    }

    public static Double getDouble(JSONObject jsonObject, String key) {
        return JSONUtils.getType(jsonObject, key, Double.class);
    }

    public static Date getDate(JSONObject jsonObject, String key) {
        Long epoch = JSONUtils.getType(jsonObject, key, Long.class);
        if (epoch == null) {
            return null;
        }
        return new Date(epoch);
    }

    private JSONUtils() {
    }
}

