/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.List;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.PrivilegeBean;
import org.apache.sqoop.model.MPrivilege;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PrivilegesBean
extends PrivilegeBean {
    private static final String PRIVILEGES = "privileges";

    public PrivilegesBean(MPrivilege privilege) {
        super(privilege);
    }

    public PrivilegesBean(List<MPrivilege> privileges) {
        super(privileges);
    }

    public PrivilegesBean() {
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONArray rolesArray = super.extractPrivileges();
        JSONObject roles = new JSONObject();
        roles.put((Object)PRIVILEGES, (Object)rolesArray);
        return roles;
    }

    @Override
    public void restore(JSONObject json) {
        JSONArray rolesArray = JSONUtils.getJSONArray(json, PRIVILEGES);
        this.restorePrivileges(rolesArray);
    }
}

