/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.List;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.model.MRole;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RoleBean
implements JsonBean {
    private static final String ROLES = "roles";
    private static final String NAME = "name";
    private List<MRole> roles;

    public List<MRole> getRoles() {
        return this.roles;
    }

    public RoleBean(MRole role) {
        this();
        this.roles = new ArrayList<MRole>();
        this.roles.add(role);
    }

    public RoleBean(List<MRole> roles) {
        this();
        this.roles = roles;
    }

    public RoleBean() {
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONArray rolesArray = this.extractRoles();
        JSONObject roles = new JSONObject();
        roles.put((Object)ROLES, (Object)rolesArray);
        return roles;
    }

    @Override
    public void restore(JSONObject json) {
        JSONArray rolesArray = JSONUtils.getJSONArray(json, ROLES);
        this.restoreRoles(rolesArray);
    }

    protected JSONArray extractRoles() {
        JSONArray rolesArray = new JSONArray();
        if (this.roles != null) {
            for (MRole role : this.roles) {
                rolesArray.add((Object)this.extractRole(role));
            }
        }
        return rolesArray;
    }

    private JSONObject extractRole(MRole role) {
        JSONObject object = new JSONObject();
        object.put((Object)NAME, (Object)role.getName());
        return object;
    }

    protected void restoreRoles(JSONArray array) {
        this.roles = new ArrayList<MRole>();
        for (Object obj : array) {
            this.roles.add(this.restoreRole(obj));
        }
    }

    private MRole restoreRole(Object obj) {
        JSONObject object = (JSONObject)obj;
        return new MRole(JSONUtils.getString(object, NAME));
    }
}

