/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.Collections;
import java.util.Date;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.model.MNamedElement;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class MAccountableEntity
extends MNamedElement {
    private static final boolean DEFAULT_ENABLED = true;
    private String creationUser;
    private Date creationDate;
    private String lastUpdateUser;
    private Date lastUpdateDate;
    private boolean enabled;

    public MAccountableEntity() {
        super(null, Collections.EMPTY_LIST);
        this.creationUser = null;
        this.creationDate = new Date();
        this.lastUpdateUser = this.creationUser;
        this.lastUpdateDate = this.creationDate;
        this.enabled = true;
    }

    public MAccountableEntity(MAccountableEntity other) {
        super(other);
        this.creationDate = other.creationDate;
        this.creationUser = other.creationUser;
        this.lastUpdateDate = other.lastUpdateDate;
        this.lastUpdateUser = other.lastUpdateUser;
        this.enabled = other.enabled;
    }

    public void setCreationUser(String name) {
        this.creationUser = name;
    }

    public String getCreationUser() {
        return this.creationUser;
    }

    public void setCreationDate(Date createDate) {
        this.creationDate = createDate != null ? new Date(createDate.getTime()) : null;
    }

    public Date getCreationDate() {
        if (this.creationDate != null) {
            return new Date(this.creationDate.getTime());
        }
        return null;
    }

    public void setLastUpdateUser(String name) {
        this.lastUpdateUser = name;
    }

    public String getLastUpdateUser() {
        return this.lastUpdateUser;
    }

    public void setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate != null ? new Date(lastUpdateDate.getTime()) : null;
    }

    public Date getLastUpdateDate() {
        if (this.lastUpdateDate != null) {
            return new Date(this.lastUpdateDate.getTime());
        }
        return null;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public boolean getEnabled() {
        return this.enabled;
    }
}

