/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.List;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MValidator;
import org.joda.time.DateTime;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MDateTimeInput
extends MInput<DateTime> {
    public MDateTimeInput(String name, boolean sensitive, InputEditable editable, String overrides, List<MValidator> mValidators) {
        super(name, sensitive, editable, overrides, mValidators);
    }

    @Override
    public String getUrlSafeValueString() {
        if (this.isEmpty()) {
            return "";
        }
        return String.valueOf(((DateTime)this.getValue()).getMillis());
    }

    @Override
    public void restoreFromUrlSafeValueString(String valueString) {
        if (valueString == null || valueString.isEmpty()) {
            this.setValue(null);
        } else {
            this.setValue(new DateTime(Long.parseLong(valueString)));
        }
    }

    @Override
    public MInputType getType() {
        return MInputType.DATETIME;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MDateTimeInput)) {
            return false;
        }
        MDateTimeInput mdi = (MDateTimeInput)other;
        return this.getName().equals(mdi.getName());
    }

    @Override
    public int hashCode() {
        return 23 + 31 * this.getName().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() == null;
    }

    @Override
    public void setEmpty() {
        this.setValue(null);
    }

    @Override
    public MDateTimeInput clone(boolean cloneWithValue) {
        MDateTimeInput copy = new MDateTimeInput(this.getName(), this.isSensitive(), this.getEditable(), this.getOverrides(), this.getCloneOfValidators());
        copy.setPersistenceId(this.getPersistenceId());
        if (cloneWithValue && this.getValue() != null) {
            copy.setValue(new DateTime(this.getValue()));
        }
        return copy;
    }
}

