/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.schema.type;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.schema.type.AbstractNumber;
import org.apache.sqoop.schema.type.ColumnType;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class Decimal
extends AbstractNumber {
    private Integer precision;
    private Integer scale;

    public Decimal(String name, Integer precision, Integer scale) {
        super(name);
        this.precision = precision;
        this.scale = scale;
    }

    public Decimal(String name, Boolean nullable, Integer precision, Integer scale) {
        super(name, nullable);
        this.precision = precision;
        this.scale = scale;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    @Override
    public ColumnType getType() {
        return ColumnType.DECIMAL;
    }

    @Override
    public String toString() {
        return "Decimal{" + super.toString() + ",precision=" + this.precision + ",scale=" + this.scale + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Decimal)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Decimal decimal = (Decimal)o;
        if (this.precision != null ? !this.precision.equals(decimal.precision) : decimal.precision != null) {
            return false;
        }
        return !(this.scale != null ? !this.scale.equals(decimal.scale) : decimal.scale != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.precision != null ? this.precision.hashCode() : 0);
        result = 31 * result + (this.scale != null ? this.scale.hashCode() : 0);
        return result;
    }
}

