/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public enum Status {
    OK,
    WARNING,
    ERROR;


    public static Status getWorstStatus(Status ... statuses) {
        Status finalStatus = OK;
        for (Status status : statuses) {
            if (finalStatus.compareTo(status) >= 1) continue;
            finalStatus = status;
        }
        return finalStatus;
    }

    public boolean canProceed() {
        return this == OK || this == WARNING;
    }

    public static Status getDefault() {
        return OK;
    }
}

