/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation.validators;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.validators.AbstractValidator;

public class DirectoryExistsValidator
extends AbstractValidator<String> {
    @Override
    public void validate(String filePath) {
        if (StringUtils.isBlank((String)filePath)) {
            return;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            this.addMessage(Status.ERROR, "Directory doesn't exists on Sqoop 2 server machine");
            return;
        }
        if (!file.isDirectory()) {
            this.addMessage(Status.ERROR, "Path is not a valid directory");
            return;
        }
    }
}

