/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.recognition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apdplat.word.util.AutoDetector;
import org.apdplat.word.util.ResourceLoader;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Punctuation {
    private static final Logger LOGGER = LoggerFactory.getLogger(Punctuation.class);
    private static char[] chars = null;

    public static void reload() {
        AutoDetector.loadAndWatch(new ResourceLoader(){

            @Override
            public void clear() {
                Punctuation.access$002(null);
            }

            @Override
            public void load(List<String> list) {
                LOGGER.info("\u521d\u59cb\u5316\u6807\u70b9\u7b26\u53f7");
                HashSet<Character> hashSet = new HashSet<Character>();
                for (String string : list) {
                    if (string.length() == 1) {
                        hashSet.add(Character.valueOf(string.charAt(0)));
                        continue;
                    }
                    LOGGER.warn("\u957f\u5ea6\u4e0d\u4e3a\u4e00\u7684\u6807\u70b9\u7b26\u53f7\uff1a" + string);
                }
                hashSet.add(Character.valueOf(' '));
                hashSet.add(Character.valueOf('\u3000'));
                hashSet.add(Character.valueOf('\t'));
                hashSet.add(Character.valueOf('\n'));
                hashSet.add(Character.valueOf('\r'));
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(hashSet);
                Collections.sort(arrayList);
                int n = arrayList.size();
                Punctuation.access$002(new char[n]);
                for (int i = 0; i < n; ++i) {
                    chars[i] = ((Character)arrayList.get(i)).charValue();
                }
                hashSet.clear();
                arrayList.clear();
                LOGGER.info("\u6807\u70b9\u7b26\u53f7\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u6807\u70b9\u7b26\u53f7\u4e2a\u6570\uff1a" + chars.length);
            }

            @Override
            public void add(String string) {
                if (string.length() != 1) {
                    LOGGER.warn("\u957f\u5ea6\u4e0d\u4e3a\u4e00\u7684\u6807\u70b9\u7b26\u53f7\uff1a" + string);
                    return;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                if (chars != null) {
                    for (char c : chars) {
                        arrayList.add(Character.toString(c));
                    }
                }
                this.clear();
                this.load(arrayList);
            }

            @Override
            public void remove(String string) {
                if (string.length() != 1) {
                    LOGGER.warn("\u957f\u5ea6\u4e0d\u4e3a\u4e00\u7684\u6807\u70b9\u7b26\u53f7\uff1a" + string);
                    return;
                }
                if (chars == null || chars.length < 1) {
                    return;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (char c : chars) {
                    arrayList.add(Character.toString(c));
                }
                int n = arrayList.size();
                arrayList.remove(string);
                if (n == arrayList.size()) {
                    return;
                }
                this.clear();
                this.load(arrayList);
            }
        }, WordConfTools.get("punctuation.path", "classpath:punctuation.txt"));
    }

    public static boolean has(String string) {
        for (char c : string.toCharArray()) {
            if (!Punctuation.is(c)) continue;
            return true;
        }
        return false;
    }

    public static List<String> seg(String string, boolean bl, char ... cArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        char[] cArray2 = string.toCharArray();
        int n2 = cArray2.length;
        block0: for (int i = 0; i < n2; ++i) {
            char c = cArray2[i];
            for (char c2 : cArray) {
                if (c == c2) continue block0;
            }
            if (!Punctuation.is(c)) continue;
            if (i > n) {
                arrayList.add(string.substring(n, i));
                n = i + 1;
            } else {
                ++n;
            }
            if (!bl) continue;
            arrayList.add(Character.toString(c));
        }
        if (n2 - n > 0) {
            arrayList.add(string.substring(n, n2));
        }
        return arrayList;
    }

    public static boolean is(char c) {
        int n = Arrays.binarySearch(chars, c);
        return n >= 0;
    }

    public static void main(String[] stringArray) {
        LOGGER.info("\u6807\u70b9\u7b26\u53f7\u8d44\u6e90");
        LOGGER.info(", : " + Punctuation.is(','));
        LOGGER.info("  : " + Punctuation.is(' '));
        LOGGER.info("\u3000 : " + Punctuation.is('\u3000'));
        LOGGER.info("\t : " + Punctuation.is('\t'));
        LOGGER.info("\n : " + Punctuation.is('\n'));
        String string = "APDPlat\u7684\u96cf\u5f62\u53ef\u4ee5\u8ffd\u6eaf\u52302008\u5e74\uff0c\u5e76\u4e8e4\u5e74\u540e\u53732012\u5e744\u67089\u65e5\u5728GITHUB\u5f00\u6e90 \u3002APDPlat\u5728\u6f14\u5316\u7684\u8fc7\u7a0b\u4e2d\uff0c\u7ecf\u53d7\u4f4f\u4e86\u4f17\u591a\u9879\u76ee\u7684\u8003\u9a8c\uff0c\u4e00\u76f4\u8ffd\u6c42\u7b80\u6d01\u4f18\u96c5\uff0c\u4e00\u76f4\u5bf9\u67b6\u6784\u3001\u8bbe\u8ba1\u548c\u4ee3\u7801\u8fdb\u884c\u91cd\u6784\u4f18\u5316\u3002 ";
        for (String string2 : Punctuation.seg(string, true, new char[0])) {
            LOGGER.info(string2);
        }
    }

    static /* synthetic */ char[] access$002(char[] cArray) {
        chars = cArray;
        return cArray;
    }

    static {
        Punctuation.reload();
    }
}

