/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.spring.boot.config;

import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.dromara.warm.flow.core.config.WarmFlow;
import org.dromara.warm.flow.orm.utils.CommonUtil;
import org.dromara.warm.plugin.modes.sb.config.BeanConfig;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"warm-flow.enabled"}, havingValue="true", matchIfMissing=true)
@MapperScan(value={"org.dromara.warm.flow.orm.mapper"})
public class FlowAutoConfig
extends BeanConfig {
    private final SqlSessionFactory sqlSessionFactory;

    public FlowAutoConfig(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public void after(WarmFlow flowConfig) {
        this.loadXml(this.sqlSessionFactory);
        CommonUtil.setDataSourceType((WarmFlow)flowConfig, (org.apache.ibatis.session.Configuration)this.sqlSessionFactory.getConfiguration());
    }

    private void loadXml(SqlSessionFactory sqlSessionFactory) {
        List<String> mapperList = Arrays.asList("warm/flow/FlowDefinitionMapper.xml", "warm/flow/FlowHisTaskMapper.xml", "warm/flow/FlowInstanceMapper.xml", "warm/flow/FlowNodeMapper.xml", "warm/flow/FlowFormMapper.xml", "warm/flow/FlowSkipMapper.xml", "warm/flow/FlowTaskMapper.xml", "warm/flow/FlowUserMapper.xml");
        org.apache.ibatis.session.Configuration configuration = sqlSessionFactory.getConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        try {
            for (String mapper : mapperList) {
                XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(Resources.getResourceAsStream((String)mapper), configuration, ((Object)((Object)this)).getClass().getResource("/") + mapper, configuration.getSqlFragments());
                xmlMapperBuilder.parse();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

